<?php

namespace App\Exceptions;
use Illuminate\Http\RedirectResponse;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of exception types with their corresponding custom log levels.
     *
     * @var array<class-string<\Throwable>, \Psr\Log\LogLevel::*>
     */
    protected $levels = [
        //
    ];

    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<\Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }
    public function render($request, Throwable $exception)
    {
        // return redirect()->back()->with('error', 'Something went wrong.');

        if ($this->isHttpException($exception)) {
            if ($exception->getStatusCode() == 404) {
                return redirect()->back()->with('info', 'Not Found (page or other resource doesn\'t exist).');
            }
            if ($exception->getStatusCode() == 401) {
                return redirect()->back()->with('info', 'Not authorized (not logged in).');
            }
            if ($exception->getStatusCode() == 400) {
                return redirect()->back()->with('info', 'Bad request (something wrong with URL or parameters).');
            }
            if ($exception->getStatusCode() == 422) {
                return redirect()->back()->with('info', 'Unprocessable Entity (validation failed).');
            }
            if ($exception->getStatusCode() == 500) {
                return redirect()->back()->with('info', 'General server error.');
            }
            if ($exception->getStatusCode() == 403) {
                return redirect()->back()->with('info', 'You don\'t have enough permission to access this page.');
            }
        }

        if ($exception instanceof NotFoundHttpException) {
            return new RedirectResponse(route('admin.dashboard')); // Replace 'dashboard' with your actual route name
        }

        return parent::render($request, $exception);
    }
}
