<?php

namespace App\Exports;

use DateTime;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use App\Models\LicenseType;

class AccountsSample implements FromCollection,WithHeadings
{
    public function dataProcessing()
    {
        $collection = LicenseType::select('id','name')->where('is_mandatory', '1')->groupBy('priority')->get();

        return $collection;
    }

    public function collection()
    {
        $rows = [];

        return collect($rows);
    }

    public function headings(): array
    {
        $data = $this->dataProcessing();

        $headings = [
            'Account Name',
            'Print Name',
            'Customer ID',
            'Phone No',
            'Whatsapp no',
            'Email',
            'Contact Person',
            'Account Group',
            'Account Type',
            'Marital Status',
            'Blood Group',
            'Gender',
            'Address Line 1',
            'Address Line 2',
            'City',
            'State',
            'Country',
            'Pin No',
            'Bank account name',
            'Account no',
            'IFSC code',
            'Bank name',
        ];

        foreach ($data as $key => $value) {
        	$headings[] = $value->name;
        }

        return $headings;
    }
}
