<?php

namespace App\Exports;

use App\Models\OpdBookings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use Maatwebsite\Excel\Events\AfterSheet;
use App\Models\IpdAdmission; 
use App\Models\Company; 
use App\Models\Account;
use App\Models\Bucket;
use App\Models\LibrarySetting\BookFormates;
use App\Models\LibrarySetting\LibrarianAuthors;
use App\Models\LibrarySetting\LibrarianGernes;
use App\Models\LibrarySetting\LibrarianPublishers;
use App\Models\Library\BookApi;
use App\Models\MenuModelPermission;
use App\Models\StorageSetting;
use App\Models\AdvanceSetting;
use App\Models\CompanyLicence;
use App\Models\AccountLicense;
use App\Models\AcReceipt;
use App\Models\Language;
use App\Models\Library\BookIssue;
use App\Models\Library\BookIssueDetail;
use App\Models\Library\LibraryCard;
use App\Models\LibrarySetting\LibrarianTags;
use App\Models\LibrarySetting\MembershipPlan;
use App\Models\LibrarySetting\Stream;
use App\Models\LibrarySetting\Translators;
use App\Models\OpdBookingDetail;
use App\Models\PaymentVoucher;
use App\Models\Product;
use App\Models\ProductLocation;
use App\Models\Purchase\PurchaseInvoiceDetails;
use App\Models\Purchase\PurchaseOthersTransaction;
use App\Models\SaleInvoiceDetail;
use App\Models\SaleOthersTransaction;
use App\Models\Sales\SaleReturnDetails;
use App\Models\Stock;
use App\Models\User;
use App\Models\VoucherType;
use GuzzleHttp\Client;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Carbon\Carbon;
use GuzzleHttp\Handler\Proxy;

class DeathRegisterStatementExport implements FromCollection
{

    protected $data;

    public function __construct($data)
    {
        $this->data = collect($data);
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $data = $this->data;

        $records[] = [
            'Reference No',
            'Case Id',
            'Patient Name',
            'Guardian Name',
            'Gender',
            'Death Date',
            'Report',
        ];

        foreach ($data as $key => $death_register) {
            $records[] =  [

                '',
                $death_register['ipd_admission_case_id'] ,
                $death_register['patient_name'] ,
                $death_register['guardian_name'] ,
                $death_register['gender_name'] ,
                \Illuminate\Support\Carbon::parse($death_register['death_date']),
                $death_register['death_report'] ,
                ];
        }

        return collect($records);
    }
}
