<?php

namespace App\Exports;

use App\Models\Library\BookIssueDetail;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class ExportBookIssue implements FromCollection,WithMapping,WithHeadings
{
        use Exportable;
        
        protected $filteredData;

        public function __construct($filteredData)
        {
            $this->filteredData = $filteredData;
        }
    
        public function collection()
        {
            return BookIssueDetail::hydrate($this->filteredData);
        }
		public function map($row):array
		{
			return [
				$row->getBookreport->book_title,
                $row->getBookreport->isbn_no,
                $row->getisseuBookreport->issue_date,
                $row->return_due_date,
                $row->getisseuBookreport->getStudents->getLibraryCard->card_no,
                $row->getisseuBookreport->getStudents->admission_no,
                $row->getisseuBookreport->getStudents->firstname,
				
			];
		}

		public function headings(): array
		{
			return [
				'Book Title',
				'Book Number',
                'Issue Date',
                'Due Return Date',
                'Library Card Number',
                'Admission No',
                'Issue By'
			];
		}

}
