<?php

namespace App\Exports;


use App\Models\Product;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Protection;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ExportBookStock implements FromCollection, WithMapping, WithHeadings, WithStyles,ShouldAutoSize
{
    use Exportable;
        
        protected $filteredData;

        public function __construct($filteredData)
        {
            $this->filteredData = $filteredData;
        }
    
        public function collection()
        {
            return Product::hydrate($this->filteredData);
        }

        public function map($row):array
		{
			return [
				$row->isbn_no?$row->isbn_no:$row->manual_isbn,
                $row->book_title,
                '',
                
			];
		}

		public function headings(): array
		{
			return [
				'book_isbn',
				'Book Title',
                'opening_stock',
			];
		}


        public function styles(Worksheet $sheet)
        {
            // Make sure you enable worksheet protection if you need any of the worksheet or cell protection features!
            $sheet->getParent()->getActiveSheet()->getProtection()->setSheet(true);
            $sheet->getStyle('C')->getProtection()->setLocked(\PhpOffice\PhpSpreadsheet\Style\Protection::PROTECTION_UNPROTECTED);
            $sheet->getStyle(1)->getFont()->setBold(true);
        }
}
