<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ExportTestItemFormat implements WithHeadings, ShouldAutoSize, WithStyles
{
    /**
    * @return \Illuminate\Support\Collection
    */
    
	public function headings(): array
	{
	    return [
	        'Test Name (required)',
	        'Test Type (TEST_ITEM, TEST_COMMENT_FOR_TECHNICIAN, TEST_LABEL)',
	        'Test Unit (required)',
	        'Result Input Type (NUMBER, TEXT, TIME, SUMMER_NOTE, OPTIONS, IMAGE, PDF)',
	        'Status (Active/Inactive)',
	    ];
	}

	public function styles(Worksheet $sheet)
	{
	    return [
	        1  => ['font' => ['bold' => true]],
	    ];
	}
}