<?php

namespace App\Exports;

use App\Models\Account;
use Maatwebsite\Excel\Concerns\Exportable;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Illuminate\Support\Facades\DB;

class IncentiveSettingExport implements FromCollection, ShouldAutoSize, WithStyles, WithHeadings
    //  , WithMapping
{
    use Exportable;

    protected $request;
    /**
     * @return \Illuminate\Support\Collection
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }
    public function collection()
    {
        $accountTypeId = $this->request->input('MasterType');
        return Account::select('accounts.name', 'accounts.code', 'account_types.type_name')
            ->leftJoin('account_types', 'accounts.account_type_id', '=', 'account_types.id')
            ->where('accounts.account_type_id', $accountTypeId)
            ->get();
    }
    public function headings(): array
    {
        return [
            'Account Name',
            'Account Code',
            'Account Type',
            'Incentive Slab',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
    // public function map($row): array
    // {
    //     return [
    //         $row->name,         // Account Name
    //         $row->code,         // Account Code
    //         $row->account_type, // Account Type
    //     ];
    // }

}