<?php

namespace App\Exports;

use App\Models\Product;
use Maatwebsite\Excel\Concerns\Exportable;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

class IncentiveSlabDetailsExport implements FromCollection, ShouldAutoSize, WithStyles, WithHeadings ,  WithEvents
    //  , WithMapping
{
    use Exportable;

    protected $request;
    /**
     * @return \Illuminate\Support\Collection
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }
    public function collection()
{
    $query = Product::select('products.name', 'products.shortcode');

    $product_brand = $this->request->input('product_brand');
    $product_category = $this->request->input('product_category');
    $product_group = $this->request->input('product_group');

    if ($product_brand !== null) {
        $query->where('products.brand_id', $product_brand);
    }

    if ($product_category !== null) {
        $query->where('products.category_id', $product_category);
    }

    if ($product_group !== null) {
        $query->where('products.composition_id', $product_group);
    }

    return $query->get();
}

    public function headings(): array
    {
        return [
            'Product Name',
            'Product Code',
            'Calculation Type',
            'Value',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                // Specify the range of cells you want to align to center.
                $event->sheet->getDelegate()->getStyle('A1:D1')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
                $event->sheet->getDelegate()->getStyle('A1:D1')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
            },
        ];
    }

}