<?php

namespace App\Exports;

use App\Models\OpdBookings;
use Maatwebsite\Excel\Concerns\FromCollection;
use App\Models\AcReceipt;
use App\Models\OpdBookingDetail;
use App\Models\SaleInvoiceDetail;
use App\Models\SaleOthersTransaction;

class IpdBillingStatementExport implements FromCollection
{

    protected $data;

    public function __construct($data)
    {
        $this->data = collect($data);
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $data = $this->data;
       

        $records[] = [
            'IPD/CASE NO',
            'Admission Dt.',
            'Patient',
            'Gender',
            'Phone No.',
            'Mobile No.',
            'Address',
            'Consultant',
            'Department',
            'Ward',
            'Age',
            'Bed',
            'Bill Amount',
            'File No',
            'Claim No',
            'Source',
            'Tpa',
            'Casualty',
            'Referal',
            'Note' ,
            'Referal Partner' ,
            'History' ,
            'Invoice Number' ,
        ];


   

        foreach ($data as $key => $admission) {
            $Receive = TransactionCalculationReceiveAmount($admission['sale_invoices_name'], 'IPD_INVOICE');
            $date_of_birth = $admission['get_patient']['account_contact']['date_of_birth'] ?? '';
            $age = $date_of_birth != '' ? age($admission['get_patient']['account_contact']['date_of_birth']) : 0;
            $records[] =  [
           
            $admission['ipd_admission_no'] ,
            \Illuminate\Support\Carbon::parse($admission['admission_date_time']),
            $admission['account_name'] ,
            $admission['get_patient']['account_contact']['gender']['name']??'' ,
            $admission['get_patient']['account_contact']['phone_no']??'' ,
            $admission['get_patient']['account_contact']['whatsapp_no']??'' ,
            $admission['get_patient']['first_account_address']['address_line1']??'',
            $admission['doctor_name'] ,
            $admission['getIpdBed']['getBedType']['name']??'' ,
            $admission['getIpdBed']['getBedGroup']['name']??'' ,
            $age ? $age .' Year(s)':' ',
            $admission['bed_name'] ,
            !empty($Receive['totalBilling']) ? $Receive['totalBilling'] : '0',
            $admission['ipd_file_no'] ,
            $admission['claim_number'] ,
            $admission['patient_source_id'] ,
            $admission['tpa_account_id'] ,
            $admission['casualty'] ,
            $admission['referal_from'] ,
            $admission['note'] ,
            $admission['referral_partner_id'] ,
            $admission['previous_medical_issue'] ,
            $admission['sale_invoice_id'] , 
            ];

          
        }

        return collect($records);
    }


   
}
