<?php

namespace App\Exports;

use App\Models\OpdBookings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use Maatwebsite\Excel\Events\AfterSheet;

class IpdDischargedStatementExport implements FromCollection
{

    protected $data;

    public function __construct($data)
    {
        $this->data = collect($data);
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $data = $this->data;
        $records = [];

        $records[] = [
            'Patient',
            'Doctor',
            'Case ID',
            'Gender',
            'Phone no.',
            'Discharge type',
            'Admission Date',
            'Discharge Date',

        ];

      
        foreach ($data as  $admission) {
            $patient         = $admission['patient_name'];
            $doctor          = $admission['doctor'];
            $case_id         = $admission['ipd_admission_no'];
            $gender          = $admission['gender'] ;
            $phone_no        = $admission['phone_no'];
            $discharge_type  = $admission['discharge_type_code']; 
            $admission_date = \Illuminate\Support\Carbon::parse($admission['admission_date_time']);
            $discharge_date = \Illuminate\Support\Carbon::parse($admission['discharge_datetime']);


            $records[] =  [
                $patient,
                $doctor,
                $case_id,
                $gender,
                $phone_no,
                $discharge_type,
                $admission_date->format('d-m-Y') . ' ' . $admission_date->format('h:i A'), 
                $discharge_date->format('d-m-Y') . ' ' . $discharge_date->format('h:i A'),
               
            ];
        }
        return collect($records);
     }

}
