<?php

namespace App\Exports\Purchase;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class PurchaseInvoiceExport implements FromCollection,WithStyles
{
    protected $data;

    public function __construct($data)
    {
        $this->data = collect($data);
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $data = $this->data;
        $records = [];

        $records[] = [
            'Date',
            'Invoice No',
            'Account Name',
            'Taxable Amt.',
            'Tax Amt.',
            'Total',
            'Dis./Adjust',
            'Net Amt.',
            'Payment',
            'Due Amt.',
        ];

      	$grand_total       = 0;
      	$texable = $tex_amt = $total = $disc = $net = $due = $ac_receipt = 0;

        foreach ($data as $key => $invoice) {
			$tax_amount = $invoice['tax_percentage'] != 0 ? taxAmountCalculate($invoice['tax_percentage'], $invoice['billing_amount']) : 0;
			$texable    += $invoice['billing_amount'] - $tax_amount + $invoice['discount_amount'];
			$tex_amt    += $tax_amount;
			$total      += $invoice['billing_amount'] + $invoice['discount_amount'];
			$disc       += $invoice['discount_amount'];
			$net        += $invoice['billing_amount'];
			$ac_receipt += $invoice['ac_receipt_amount'];
			$deduct     = 0;
			$deduct     += $invoice['ac_receipt_amount'];
			$due        += $invoice['billing_amount'] - $deduct;

            $patient = $invoice['get_patient'];

            $invoice_date = $invoice['invoice_date'];
            $records[] =  [
                formatedDateTimeForBill($invoice_date),
                ($invoice['main_invoice_no'] ?? ''),
                (isset($patient) &&  $patient['name']!=''? $patient['name'] : '') . ', ' . (isset($patient) && $patient['code']!=''? $patient['code'] : ''),
                ($invoice['billing_amount'] - $tax_amount + $invoice['discount_amount']) ?? '0',
                $tax_amount ?? 0,
                (($invoice['billing_amount'] + $invoice['discount_amount']) ?? '0'),
                $invoice['discount_amount'] ?? '0',
                $invoice['billing_amount'] ?? '0',
                $deduct ?? '0',
                $invoice['billing_amount'] - $deduct ?? '0'
            ];
        }

        $records[] =  [
            '',
            '',
            'Total',
            $texable,
            $tex_amt,
            $total,
            $disc,
            $net,
            $ac_receipt,
            $due,
        ];

        return collect($records);
    } 



    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle(1)->getFont()->setBold(true);

        // Get the last row number
        $lastRow = $sheet->getHighestRow();

        // Apply bold font style to the last row
        $sheet->getStyle($lastRow)->getFont()->setBold(true);
        
        return [
            // Styling the first row (headings)
            'C' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Taxable Amt"
            'D' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Tax Amt"
            'E' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Total"
            'F' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Dis./Adjust"
            'G' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Net Amt"
            'H' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Payment"
            'I' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Due Amt"
            'J' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Due Amt"
        ];
    }
}
