<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use Maatwebsite\Excel\Events\AfterSheet;

class SaleStatementExport implements FromCollection
{
    protected $data;

    public function __construct($data)
    {
        $this->data = collect($data);
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $data = $this->data;
        $records = [];

        $records[] = [
            'Date',
            'Bill To',
            'Account Name',
            'Voucher Type',
            'Taxable Amt.',
            'Tax Amt.',
            'Total',
            'Dis./Adjust',
            'Net Amt.',
            'Received/Paid Amount',
            'Due Amt.',
        ];

      	$grand_total       = 0;
      	$texable = $tex_amt = $total = $disc = $net = $due = $ac_receipt = 0;

        foreach ($data as $key => $invoice) {
			$tax_amount = $invoice['tax_percentage'] != 0 ? $this->taxAmountCalculate($invoice['tax_percentage'], $invoice['billing_amount']) : 0;
			$texable    += $invoice['billing_amount'] - $tax_amount + $invoice['discount_amount'];
			$tex_amt    += $tax_amount;
			$total      += $invoice['billing_amount'] + $invoice['discount_amount'];
			$disc       += $invoice['discount_amount'];
			$net        += $invoice['billing_amount'];
			$ac_receipt += $invoice['ac_receipt_amount'];
			$deduct     = 0;
			$deduct     += $invoice['ac_receipt_amount'];
			$due        += $invoice['billing_amount'] - $deduct;

            $invoice_date = \Illuminate\Support\Carbon::parse($invoice['invoice_date']);
            $records[] =  [
                $this->formatedDate($invoice_date),
                ($invoice['main_invoice_no'] ?? ''),
                ($invoice['patient'] ?? '') . ' ' . ($invoice['patient_code'] ?? ''),
                ($invoice['voucher_type_code'] ?? '0'),
                ($invoice['billing_amount'] - $tax_amount + $invoice['discount_amount']) ?? '0',
                $tax_amount ?? 0,
                (($invoice['billing_amount'] + $invoice['discount_amount']) ?? '0'),
                $invoice['discount_amount'] ?? '0',
                $invoice['billing_amount'] ?? '0',
                $deduct ?? '0',
                $invoice['billing_amount'] - $deduct ?? '0'
            ];
        }

        $records[] =  [
            '',
            '',
            '',
            'Total',
            $texable,
            $tex_amt,
            $total,
            $disc,
            $net,
            $ac_receipt,
            $due,
        ];

        return collect($records);
    } 

    private function formatedDate($dateTime)
    {
        return $dateTime->format('d-m-Y') . " " . $dateTime->format('h:i A');
    }

    private function taxAmountCalculate($tax_percentage, $total_amount)
    {
        return ($tax_percentage / 100) * $total_amount;
    }
}
