<?php

namespace App\Exports;

use Carbon\Carbon;
use App\Models\Account;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithChunkReading;


class StatementsExport implements FromCollection, WithMapping, WithHeadings
{
    use Exportable;

    protected $request;
    /**
     * @return \Illuminate\Support\Collection
     */
    public function __construct($filteredData)
    {
        $this->request  = new Request(request()->all());
        // $this->filteredData = $filteredData;
    }
    public function collection()
    {
        $request = $this->request;
        $data = Account::select([
            'accounts.*',
            'accounting_groups.name as group_name',
            'account_addresses.address_line1 as address',
            'countries.name as country',
            'states.name as state',
            'cities.name as city',
            'account_contacts.phone_no',
            'account_contacts.email',
            'account_contacts.account_gender_id',
            'account_contacts.date_of_birth',
            'genders.name as gender',
            'lms_classes.class_name',
            'lms_sections.section',
            'student_houses.name as house_name',
            'student_admissions.student_id',
            'account_categories.category_name AS category',
        ])
            ->leftjoin('account_contacts','account_contacts.account_id','accounts.id')
            ->leftjoin('accounting_groups','accounting_groups.id','accounts.accounting_group_id')
            ->leftjoin('account_addresses','account_addresses.account_id','accounts.id')
            ->leftjoin('countries', 'countries.id', 'account_addresses.country_id')
            ->leftjoin('states', 'states.id', 'account_addresses.state_id')
            ->leftjoin('cities', 'cities.id', 'account_addresses.city_id')
            ->leftjoin('account_categories', 'account_categories.id', 'accounts.account_category_id')
            ->leftjoin('genders', 'genders.id', 'account_contacts.account_gender_id')
            ->leftjoin('account_types', 'account_types.id', 'accounts.account_type_id')
            ->leftjoin('student_houses', 'student_houses.id', 'accounts.house_group_id')
            ->leftjoin('student_admissions', 'accounts.id', 'student_admissions.student_id')
            ->leftjoin('lms_classes', 'lms_classes.id', 'student_admissions.class_id')
            ->leftjoin('lms_sections', 'lms_sections.id', 'student_admissions.section_id');

        if (isset($request->gender) && $request->gender != '') {
            $data->where('account_contacts.account_gender_id', $request->gender);
        }

        if (isset($request->house) && $request->house != '') {
            $data->where('accounts.house_group_id', $request->house);
        }

        if (isset($request->class) && $request->class != '') {
            $data->where('student_admissions.class_id', $request->class);
        }

        if (isset($request->section) && $request->section != '') {
            $data->where('student_admissions.section_id', $request->section);
        }

        if (isset($request->category) && $request->category != '') {
            $data->where('accounts.account_category_id', $request->category);
        }

        return $data->where('account_types.type_name', 'like', '%Student%')->get();
    }

    public function headings(): array
    {
        return [
            'Admission No',
            'Student Name',
            'Date of Birth',
            'Gender',
            'Category',
            'Phone No',
            'House',
            'Class',
            'Section',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }

    public function map($row):array
    {
        return [
            $row->unique_register_no,
            $row->name,
            $row->date_of_birth,
            $row->gender,
            $row->category,
            $row->phone_no . ' ',
            $row->house_name,
            $row->class_name,
            $row->section,
        ];
    }
}