<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class StockReorderListExport implements FromCollection,WithHeadings
{
    protected $data;

    public function __construct($data)
    {
        $this->data = collect($data);
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $data = $this->data;
        $records = [];
        $i = 1;

        foreach ($data as $key => $invoice) {
            $exp_date = $invoice['exp_date'];

            $records[] =  [
                $i,
                ($invoice['product_name'] ?? ''),
                ($invoice['primary_unit'] ?? ''),
                ($invoice['batch'] ?? ''),
                formatedDateTimeForBill($exp_date),
                number_format($invoice['stock_in_count'], 2, '.', ''),
                number_format($invoice['stock_out_count'], 2, '.', ''),
                number_format(($invoice['stock_in_count'] - $invoice['stock_out_count']), 2, '.', ''),
                number_format(($invoice['item_min_stock_qty']), 2, '.', ''),
                number_format($invoice['taxable_unit_price'], 2, '.', '')
            ];

            $i++;
        }

        return collect($records);
    }

    public function headings(): array
    {
        $headings = [
            'Sl No',
            'Product Name',
            'UOM',
            'Batch',
            'Expiry Date',
            'STOCK IN',
            'STOCK Out',
            'CURRENT STOCK',
            'STOCK Value',
            'Min Stock',
        ];

        return $headings;
    }
}
