<?php

namespace App\Exports\Stocks;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class StockInExportStatement implements FromCollection,WithStyles
{
    protected $data;

    public function __construct($data)
    {
        $this->data = collect($data);
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $data = $this->data;
        $records = [];

        $records[] = [
            'Date',
            'Voucher No',
            'Taxable Amt.',
            'Tax Amt.',
            'Total',
            'Dis./Adjust',
            'Net Amt.',
        ];

      	$grand_total       = 0;
      	$texable = $tex_amt = $total = $disc = $net = $due = $ac_receipt = 0;
      
        foreach ($data as $key => $invoice) {
			$tax_amount = $invoice['tax_percentage'] != 0 ? taxAmountCalculate($invoice['tax_percentage'], $invoice['billing_amount']) : 0;
			$texable    += $invoice['billing_amount'] - $tax_amount + 0;
			$tex_amt    += $tax_amount;
			$total      += $invoice['billing_amount'] + 0;
			$disc       += 0;
			$net        += $invoice['billing_amount'];

            $invoice_date = $invoice['invoice_date'];
            $records[] =  [
                formatedDateTimeForBill($invoice_date),
                ($invoice['main_invoice_no'] ?? ''),
                ($invoice['billing_amount'] - $tax_amount + 0) ?? '0',
                $tax_amount ?? 0,
                (($invoice['billing_amount'] + 0) ?? '0'),
                0 ?? '0',
                $invoice['billing_amount'] ?? '0',
            ];
        }

        $records[] =  [
            '',
            'Total',
            $texable,
            $tex_amt,
            $total,
            $disc,
            $net,
        ];

        return collect($records);
    } 


   
    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle(1)->getFont()->setBold(true);

        // Get the last row number
        $lastRow = $sheet->getHighestRow();

        // Apply bold font style to the last row
        $sheet->getStyle($lastRow)->getFont()->setBold(true);
        
        return [
            // Styling the first row (headings)
            'C' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Amount"
            'D' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Amount"
            'E' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Amount"
            'F' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Amount"
            'G' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Amount"
        ];
    }
}
