<?php

namespace App\Exports;

use Carbon\Carbon;
use App\Models\Account;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithChunkReading;


class StudentsExport implements FromCollection, WithMapping, WithHeadings
{
    use Exportable;

    protected $filteredData;
    /**
     * @return \Illuminate\Support\Collection
     */
    public function __construct($filteredData)
    {
        $this->filteredData = $filteredData;
    }
    public function collection()
    {
        return Account::select([
            'accounts.*',
            'accounting_groups.name as group_name',
            'account_addresses.address_line1 as address',
            'countries.name as country',
            'states.name as state',
            'cities.name as city',
            'account_contacts.phone_no',
            'account_contacts.email',
            'account_contacts.account_gender_id',
            'account_contacts.date_of_birth',
            'genders.name as gender',
            'account_categories.category_name AS category',
        ])
            ->leftjoin('account_contacts','account_contacts.account_id','accounts.id')
            ->leftjoin('accounting_groups','accounting_groups.id','accounts.accounting_group_id')
            ->leftjoin('account_addresses','account_addresses.account_id','accounts.id')
            ->leftjoin('countries', 'countries.id', 'account_addresses.country_id')
            ->leftjoin('states', 'states.id', 'account_addresses.state_id')
            ->leftjoin('cities', 'cities.id', 'account_addresses.city_id')
            ->leftjoin('account_categories', 'account_categories.id', 'accounts.account_category_id')
            ->leftjoin('genders', 'genders.id', 'account_contacts.account_gender_id')
            ->leftjoin('account_types', 'account_types.id', 'accounts.account_type_id')
            ->where('account_types.type_name', 'like', '%Student%')
            ->get();
    }

    public function headings(): array
    {
        return [
            'Admission No',
            'Student Name',
            'Date of Birth',
            'Gender',
            'Category',
            'Phone No',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }

    public function map($row):array
    {
        return [
            $row->unique_register_no,
            $row->name,
            $row->date_of_birth,
            $row->gender,
            $row->category,
            $row->phone_no . ' '
        ];
    }
}