<?php

namespace App\Exports;

use App\Models\AccountTransaction;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class TransactionExport implements FromCollection, WithMapping, WithHeadings,WithStyles
{
    use Exportable;

    protected $filteredData;

    public function __construct($filteredData)
    {
        $this->filteredData = $filteredData;
    }

    public function collection()
    {
        return AccountTransaction::hydrate($this->filteredData);
    }
    public function map($row): array
    {
        if($row->module_code === 'CONTRA') {
            $voucherNo = $row->contraVoucher->voucher_no ?? '';
        }elseif ($row->module_code === 'PAYMENT_VOUCHER') {
            $voucherNo = $row->paymentVoucher->receipt_no ?? '';
        }elseif ($row->module_code === 'JOURNAL_VOUCHER') {
            $voucherNo = $row->journalVoucher->voucher_no ?? '';
        }elseif ($row->module_code === 'Receipt_VOUCHER') {
            $voucherNo = $row->receiptVoucher->receipt_no ?? '';
        }elseif ($row->module_code === 'PATHOLOGY_LAB_BILLING' || $row->module_code === 'Pathology' || $row->module_code === 'PATHOLOGY') {
            $voucherNo = $row->pathologyVoucher->main_invoice_no ?? '';
        }elseif ($row->module_code === 'OPD_BOOKING') {
            $voucherNo = $row->OpdVoucher->booking_no ?? '';
        }elseif ($row->module_code === 'IPD_ADMISSION' || $row->module_code === 'IPD_INVOICE') {
            $voucherNo = $row->IPDAdmissionVoucher->ipd_admission_no ?? '';
        }elseif ($row->module_code === 'SALES') {
            $voucherNo = $row->SalesVoucher->main_invoice_no ?? '';
        }
        if ($row->voucher_type['code'] == 'RECEIPT') {
            $receiptNo = $row->receiptVoucher->receipt_no ?? '';
        }

        if ($row->transaction_type == 'DEBIT') {
            $debitAmount =   $row->amount ? convertDecimelPoint($row->amount) : 0;
        }

        if ($row->transaction_type == 'CREDIT') {
            $creditAmount =   $row->amount ? convertDecimelPoint($row->amount) : 0;
        }

        return [
            $row->transactions_no ?? '',
            formatedDate($row->transaction_date),
            $voucherNo ?? '',
            $row->voucher_type['name'] ?? '',
            $receiptNo??'',
            $row->Account->name ?? '' . ' A/C ' . $row->transaction_type ?? '',
            $debitAmount??'',
            $creditAmount??''

        ];
    }

    public function headings(): array
    {
        return [
            'Transactions No.',
            'Transactions Date',
            'Voucher No',
            'Voucher Type',
            'Receipt No',
            'Account Name',
            'Debit Amount',
            'Credit Amount'
        ];
    }
    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle(1)->getFont()->setBold(true);
        return [
            // Styling the first row (headings)
            'G' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Debit Amount"
            'H' => ['alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT]], // "Credit Amount"
        ];
    }
}
