<?php

namespace App\Helpers;

use App\Models\Attachment;
use App\Models\CollectionCenter;
use App\Models\User;
use App\Models\UserNotification;
use App\Notifications\EmailNotification;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class SiteHelper
{
    public static function reformatDbDateTime($datetimeStr)
    {

        if (!empty($datetimeStr)) {
            return Carbon::createFromFormat('d/m/Y H:i', $datetimeStr)->format('Y-m-d H:i:s');
        } else {
            return NULL;
        }
    }

    public static function reformatDbDate($dateStr)
    {
        if (!empty($dateStr)) {
            return Carbon::createFromFormat('d/m/Y H:i:s', "{$dateStr} 00:00:00")->format('Y-m-d');
        } else {
            return NULL;
        }
    }

    public static function reformatDate($date)
    {
        if (!empty($date)) {
            return Carbon::createFromFormat('Y-m-d H:i:s', "{$date} 00:00:00");
        } else {
            return NULL;
        }
    }

    public static function reformatReadableDateTime($datetimeStr)
    {

        if (!empty($datetimeStr)) {
            return Carbon::createFromFormat('Y-m-d H:i:s', $datetimeStr)->format('d/m/Y H:i');
        } else {
            return NULL;
        }
    }

    public static function reformatReadableDate($dateStr)
    {
        if (!empty($dateStr)) {
            return Carbon::createFromFormat('Y-m-d H:i:s', "{$dateStr} 00:00:00")->format('d/m/Y');
        } else {
            return NULL;
        }
    }

    public static function checkPermission($menu_key)
    {
        if (Auth::user()->menus->where('menu_key', $menu_key)->isNotEmpty()) {
            return true;
        } else {
            return false;
        }
    }

    public static function reformatReadableDateNice($dateStr)
    {
        if (!empty($dateStr)) {
            return Carbon::parse($dateStr)->format('d M, Y');
        } else {
            return false;
        }
    }

    public static function getPreviousMonth($date)
    {
        if (!empty($date)) {
            return Carbon::parse($date)->subMonth()->format('Y-m');
        } else {
            return false;
        }
    }

    public static function reformatReadableMonthNice($date)
    {
        if (!empty($date)) {
            return Carbon::parse($date)->format('M/Y');
        } else {
            return false;
        }
    }

    public static function do_upload_file($request, $column_name, $ModelObject, $folder_name)
    {
        //delete previous image if has any
        if (!empty($ModelObject[$column_name])) {
            File::delete("public/uploads/" . $folder_name . '/' . $ModelObject[$column_name]);
        }

        if (!empty($request[$column_name])) {
            $image_base64 = $request[$column_name];
            $folderPath = "public/uploads/" . $folder_name . '/'; //path location
            $image_parts = explode(";base64,", $image_base64);
            $image_type_aux = explode("image/", $image_parts[0]);
            $extension = $image_type_aux[1];
            $image_base64 = base64_decode($image_parts[1]);
            $fileName = uniqid() . "_" . $ModelObject->id;
            $file = $folderPath . $fileName . '.' . $extension;
            file_put_contents($file, $image_base64);
            $image = $fileName . '.' . $extension;
            return $image;
        } else {
            return '';
        }
    }

}
