<?php

namespace App\Http\Controllers\APIManagement;

use App\Http\Controllers\Controller;
use App\Http\Requests\SMSTemplateRequest;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Category;
use App\Models\SmsTemplate;
use App\Models\SmsApiSetting;

use Datatables;
use Illuminate\Support\Facades\Auth;
use Validator;

class SmsAPITemplateController extends Controller
{

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function smsapi(Request $request)
    {
        $SmsApi = SmsApiSetting::where(['company_id' => 1])->first();
        //
        return view('smstemplate.smsapi')->with(['SmsApi' => $SmsApi]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function updatesmsapi(Request $request)
    {
        $validator =  Validator::make($request->all(), [
            'user_name' => 'required',
            'password' => 'required',
            'principal_entity_id' => 'required',
            'sms_signature' => 'required',
            'sms_notify_mobile' => 'required',
            'sms_notify_email' => 'required',
            'sms_notify_url' => 'required',
            'enable_sms_api' => 'required',
        ]);
        if ($validator->fails()) {
            //return redirect()->back()->withErrors($validator)->withInput();
            return response()->json(['success' => false, 'message' => $validator->errors()->all()]);
        } else {
            $CheckSetting = SmsApiSetting::where(['company_id' => 1])->first();
            if (empty(json_decode($CheckSetting))) {
                $SmsApiSetting = SmsApiSetting::create([
                    'company_id'            => 1,
                    'user_name'             => $request->user_name,
                    'password'              => $request->password,
                    'principal_entity_id'   => $request->principal_entity_id,
                    'sms_signature'         => $request->sms_signature,
                    'sms_notify_mobile'     => $request->sms_notify_mobile,
                    'sms_notify_email'      => $request->sms_notify_email,
                    'sms_notify_url'        => $request->sms_notify_url,
                    'enable_sms_api'        => $request->enable_sms_api,
                    'status' => '1',
                ]);
            } else {
                $data = array(
                    'user_name'             => $request->user_name,
                    'password'              => $request->password,
                    'principal_entity_id'   => $request->principal_entity_id,
                    'sms_signature'         => $request->sms_signature,
                    'sms_notify_mobile'     => $request->sms_notify_mobile,
                    'sms_notify_email'      => $request->sms_notify_email,
                    'sms_notify_url'        => $request->sms_notify_url,
                    'enable_sms_api'        => $request->enable_sms_api,
                );
                $SmsApiSetting = SmsApiSetting::where(['company_id' => 1])->update($data);
            }

            //
            $Redirect = '';
            return response()->json([
                'success' => true,
                'message' => ['Setting successfully updated'],
                'data' => [
                    'redirect' => $Redirect,
                    'reload' => true,
                ]
            ]);
        }
    }
    /**
     * change category status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = SmsTemplate::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Sms Template status successfully change'],
                    'data' => [
                        'redirect' => 'smstemplate',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete = SmsTemplate::where(['id' => $request->id])->delete();
        $Redirect = 'smstemplate';
        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
