<?php

namespace App\Http\Controllers\APIManagement;

use App\Http\Controllers\Controller;
use App\Http\Requests\SMSTemplateRequest;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Category;
use App\Models\SmsTemplate;
use App\Models\SmsApiSetting;

use Datatables;
use Illuminate\Support\Facades\Auth;
use Validator;

class SmsTemplateController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:smstemplate-list|smstemplate-create|smstemplate-edit|smstemplate-delete', ['only' => ['index', 'store']]);
    }
    /**
     * 
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = SmsTemplate::with('getComapnyName')->paginate(10);
        if ($request->ajax()) {

            //Server Side Data
            $sort_by = $request->get('sortby');
            $sort_type = $request->get('sorttype');
            $query = $request->get('query');

            if (!empty($query) && !empty($sort_by) && $query != " ") {
                $data = SmsTemplate::query()->with('getComapnyName')->where('template_use_for', 'like', '%' . $query . '%')->paginate($sort_by);
            } elseif ($sort_by) {
                $data = SmsTemplate::with('getComapnyName')->paginate($sort_by);
            } else {
                $data = SmsTemplate::with('getComapnyName')->paginate(10);
            }

            return view('smstemplate.table', compact('data'));
        } else {
            return view('smstemplate.index', compact('data'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        return view('smstemplate.create');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(SMSTemplateRequest $request)
    {
        if ($request->isMethod('post')) {

            $request->validated();
            SmsTemplate::create([
                'company_id'        => Auth::user()->id,
                'template_use_for'  => $request->template_used_for,
                'template_id'       => $request->template_id,
                'sender_id'         => $request->sender_id,
                'sms_signature'     => $request->sms_signature,
                'template_format'   => $request->template_format,
                'sms_title'         => $request->sms_title,
                'sms_body'          => $request->sms_body,
                'status'            => '1',
            ]);


            $CheckSetting = SmsApiSetting::where(['company_id' => 1])->first();
            if (empty(json_decode($CheckSetting)))
            {
                $SmsApiSetting = SmsApiSetting::create(
                    [
                        'company_id'            => 1,
                        'principal_entity_id'   => $request->principal_entiry_id,
                        'status'                => '1',
                    ]
                );
            }
            else
            {
                $data = [
                    'principal_entity_id'   => $request->principal_entiry_id,
                ];
                $SmsApiSetting = SmsApiSetting::where(['company_id' => 1])->update($data);
            }
            return redirect('smstemplate')->with('success', 'SmsTemplate successfully created');
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(SmsTemplate $smstemplate)
    {
        $SmsTemplate = SmsTemplate::where(['id' => $smstemplate->id])->first();
        $smssetting  = SmsApiSetting::where(['company_id' => 1])->first();
        return view('smstemplate.edit')->with(['SmsTemplate' => $SmsTemplate,'smssetting'=>$smssetting]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(SMSTemplateRequest $request)
    {
        $request->validated();
        $data = array(
            'template_use_for' => $request->template_used_for,
            'template_id' => $request->template_id,
            'sender_id' => $request->sender_id,
            'sms_signature' => $request->sms_signature,
            'template_format' => $request->template_format,
        );
        SmsTemplate::where(['id' => $request->id])->update($data);


        $CheckSetting = SmsApiSetting::where(['company_id' => 1])->first();
        if (empty(json_decode($CheckSetting)))
        {
            $SmsApiSetting = SmsApiSetting::create(
                [
                    'company_id'            => 1,
                    'principal_entity_id'   => $request->principal_entiry_id,
                    'status'                => '1',
                ]
            );
        }
        else
        {
            $data = [
                'principal_entity_id'   => $request->principal_entiry_id,
            ];
            $SmsApiSetting = SmsApiSetting::where(['company_id' => 1])->update($data);
        }

        return redirect('smstemplate')->with('success', 'SmsTemplate successfully updated');
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function smsapi(Request $request)
    {
        $SmsApi = SmsApiSetting::where(['company_id' => 1])->first();
        //
        return view('smstemplate.smsapi')->with(['SmsApi' => $SmsApi]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function updatesmsapi(Request $request)
    {
        $validator =  Validator::make($request->all(), [
            'user_name' => 'required',
            'password' => 'required',
            'principal_entity_id' => 'required',
            'sms_signature' => 'required',
            'sms_notify_mobile' => 'required',
            'sms_notify_email' => 'required',
            'sms_notify_url' => 'required',
            'enable_sms_api' => 'required',
        ]);
        if ($validator->fails()) {
            //return redirect()->back()->withErrors($validator)->withInput();
            return response()->json(['success' => false, 'message' => $validator->errors()->all()]);
        } else {
            $CheckSetting = SmsApiSetting::where(['company_id' => 1])->first();
            if (empty(json_decode($CheckSetting))) {
                $SmsApiSetting = SmsApiSetting::create([
                    'company_id' => 1,
                    'user_name' => $request->user_name,
                    'password' => $request->password,
                    'principal_entity_id' => $request->principal_entity_id,
                    'sms_signature' => $request->sms_signature,
                    'sms_notify_mobile' => $request->sms_notify_mobile,
                    'sms_notify_email' => $request->sms_notify_email,
                    'sms_notify_url' => $request->sms_notify_url,
                    'enable_sms_api' => $request->enable_sms_api,
                    'status' => '1',
                ]);
            } else {
                $data = array(
                    'user_name' => $request->user_name,
                    'password' => $request->password,
                    'principal_entity_id' => $request->principal_entity_id,
                    'sms_signature' => $request->sms_signature,
                    'sms_notify_mobile' => $request->sms_notify_mobile,
                    'sms_notify_email' => $request->sms_notify_email,
                    'sms_notify_url' => $request->sms_notify_url,
                    'enable_sms_api' => $request->enable_sms_api,
                );
                $SmsApiSetting = SmsApiSetting::where(['company_id' => 1])->update($data);
            }

            //
            $Redirect = '';
            return response()->json([
                'success' => true,
                'message' => ['Setting successfully updated'],
                'data' => [
                    'redirect' => $Redirect,
                    'reload' => true,
                ]
            ]);
        }
    }
    /**
     * change category status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = SmsTemplate::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Sms Template status successfully change'],
                    'data' => [
                        'redirect' => 'smstemplate',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete = SmsTemplate::where(['id' => $request->id])->delete();
        $Redirect = 'smstemplate';
        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
