<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AbdmApi;
use App\Models\StudentHouse;

class AbdmApiController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       $abdm_apis = AbdmApi::select(
            'abdm_apis.id as id',
            'abdm_apis.provider as provider',
            'abdm_apis.api_status as api_status',
            'abdm_apis.status as status'
        )->orderBy('abdm_apis.provider', 'ASC');

        if ($request->ajax()) {
            $sort_by      = $request->get('sortby') ?? 10;
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $abdm_apis = $abdm_apis->when(!empty($search_query), function ($query) use ($search_query) {
                return $query->where('abdm_apis.provider', 'like', '%'.$search_query.'%');
            })->paginate($sort_by);

            return view('abdm_apis.table', compact('abdm_apis'));
        } else {
            $abdm_apis = $abdm_apis->paginate(10);

            return view('abdm_apis.index', compact('abdm_apis'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AbdmApiController  $abdmApiController
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AbdmApiController  $abdmApiController
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       $abdm_apis = AbdmApi::findOrFail($id);

        return view('accounts.edit-abdm_apis', compact('abdm_apis'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AbdmApiController  $abdmApiController
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AbdmApiController  $abdmApiController
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $abdm_apis = AbdmApi::findOrFail($id);
        $abdm_apis->delete();

        return response()->json([
            'success' => true,
            'message' => 'Abdm Api deleted successfully',
            'data' => [
                'redirect' => '', 
            ]
        ]);
    }

    public function createAbdmApi()
    {
      $abdm_apis = AbdmApi::select(
            'abdm_apis.id as id',
            'abdm_apis.provider as provider',
            'abdm_apis.api_status as api_status',
            'abdm_apis.status as status'
        )->get();

       $abdm_apis_id =  AbdmApi::select('abdm_apis.id as abdm_apis_id')
       ->get();

        return view('accounts.create-abdm_apis', compact('abdm_apis' , 'abdm_apis_id'));  
    }


    public function storeAbdmApi(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'provider'         => 'required',
            'sandbox_token'    => 'nullable',
            'production_token' => 'nullable',
        ]);

        if ($validator->fails()) {

            return response()->json([
                'success'  => false,
                'message'  => $validator->getMessageBag()->first(),
                'data'     => [
                'redirect' => 'abdm-apis.index'],
            ]);
        }

        $abdm_apis = AbdmApi::create([
            'provider'         => $request->provider,
            'sandbox_token'    => $request->sandbox_token,
            'production_token' => $request->production_token,
        ]);

        return response()->json([
            'success'  => true,
            'message'  => 'Api created successfully',
            'data'     => [
            'redirect' => 'abdm-apis.index', 
            ]
        ]);
    }

    public function changeStatusApi(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('api_status' => $request->status );
            $update = AbdmApi::where('id', '=', $request->id)->update($data);

            if($update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Api status successfully change'],
                    'data'=>[
                       'redirect'=>'/users/',
                       'reload'=>true,
                    ]
                ]);
            } else {
                return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
                ]);
            }
        }
    }



    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('status' => $request->status );
            $update = AbdmApi::where('id', '=', $request->id)->update($data);

            if($update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Api status successfully change'],
                    'data'=>[
                       'redirect'=>'/users/',
                       'reload'=>true,
                    ]
                ]);
            } else {
                return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
                ]);
            }
        }
    }

    public function updateAbdmApi(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'provider'         => 'required',
            'sandbox_token'    => 'nullable',
            'production_token' => 'nullable',
        ]);

        if ($validator->fails()) {
           return response()->json([
                'success'  => false,
                'message'  => $validator->getMessageBag()->first(),
                'data'     => [
                'redirect' => 'abdm-apis.index'],
            ]);
        }

        $abdm_apis = AbdmApi::findOrFail($id);
        $abdm_apis->update($request->all());

        return response()->json([
            'success'  => true,
            'message'  => 'Abdm Api updated successfully',
            'data'     => [
            'redirect' => 'abdm-apis.index', 
            ]
        ]);
    }

  





}
