<?php

namespace App\Http\Controllers\Accounting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AccountTransaction;
use App\Models\Company;
use App\Models\User;
use App\Models\VoucherType;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\AcReceipt;
use App\Models\AcReceiptDetail;
use App\Models\PaymentVoucher;
use App\Models\PaymentVoucherDetail;

class ConsolidateStatementController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $company            = Company::find(Auth::user()->company_id);
        $companyDateFormate = phpToJsDateFormat($this->companyDateFormate());
        $from_date          = $request->from_date ? date('Y-m-d', strtotime($request->from_date)):date('Y-m-d');
       
        if($request->ajax()) 
        {
            // 1st Table 
            $filters['from_date'] = $from_date;
            $filters['branch']    = $branch          = $request->branch ?? '';
            $accountReceipt       = AcReceipt::getReceiptVouchers($filters);

            // 2nd Table 
            $filters['from_date']   = '';
            $filters['date_before'] = $from_date;
            $accountReceiptOld      = AcReceipt::getReceiptVouchers($filters);
            
            // 3rd Table
            $accountReceiptNew    = $accountReceipt;

            // 4th Table 
            $paymentVoucher = $this->queryFilter($request);

            return response()->json([
                'status'            => true,
                'from_date'         => $from_date,
                'branch'            => $branch,
                'accountReceipt'    => $accountReceipt,
                'accountReceiptOld' => $accountReceiptOld,
                'accountReceiptNew' => $accountReceiptNew,
                'company'           => $company,
                'paymentVoucher'    => $paymentVoucher,
            ]);

            return view('consolidate-statement.statement-table', compact( 
                'from_date',
                'branch',
                'accountReceipt',
                'accountReceiptOld',
                'company',
                'accountReceiptNew',
                'paymentVoucher',
            ));
        }

        return view('consolidate-statement.statement', compact(
            'company',
            'companyDateFormate',
            'from_date',
        ));
    }




    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


     function queryFilter(Request $request){

        $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)):date('Y-m-d');
        $branch    = $request->branch ?? '';
       
        $paymentVoucher = PaymentVoucher::with(
            'company',
            'paymentVoucherDetail',
            'paymentVoucherDetails.company',
            'paymentVoucherDetails.user',
            'paymentVoucherDetails.account',
            'paymentVoucherDetails.module'
        )
        ->when($from_date != '' , function($query) use($from_date) {
            $query->whereDate('receipt_date', 
                date('Y-m-d', strtotime($from_date))
            );
        })
        ->when($branch != '', function($query) use($branch) {
            $query->where('payment_vouchers.company_id', $branch);
        })
        ->groupBy('payment_vouchers.id')
        ->get();

        return $paymentVoucher;
    }

}
