<?php

namespace App\Http\Controllers\Accounts;

use Illuminate\Http\Request;
use App\Models\AccountBank;
use App\Http\Controllers\Controller;

class AccountBanksController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:account-banks-list', ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $priority = AccountBank::max('priority');
        $priority = $priority != '' ? $priority : 0;

        return view('account-banks.create', compact('id','priority'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'account_id'   => 'required',
            'account_name' => 'required',
            'account_no'   => 'required',
            'bank_name'    => 'required',
            'branch_name'  => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);

        $default_check = AccountBank::where(['is_default' => '1','status' => '1', 'account_id' => $request->account_id])->first();

        if (!$default_check) {
            $data['is_default'] = '1';
        }

        $quality = AccountBank::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Bank details has been created successfully',
            ]);
        }
        return redirect()->back()
            ->with('success','Bank details has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $bank = AccountBank::find($id);

        return view('account-banks.edit', compact('bank'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'account_name' => 'required',
            'account_no'   => 'required',
            'bank_name'    => 'required',
            'branch_name'  => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);

        $bank = AccountBank::find($id);

        if (!$bank) {
            return redirect()->back()
                ->with('error','Account bank not found!');
        }

        $bank->update($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Bank details has been updated successfully',
            ]);
        }
        return redirect()->back()
            ->with('success','Bank details has been updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $account = AccountBank::find($request->id);

        if ($account->is_default == '1') {
            return response()->json([
                'success' => false,
                'message' => ['Default record can not be deleted.']
            ]);
        }

        $account->delete();

        $Redirect = 'accounts';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data'    => [
                'reload' => true,
            ]
        ]);
    }

   public function changeStatus(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = AccountBank::where(['id' => $request->id])->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Account Bank status successfully change'],
                   'data'=>[
                       'redirect'=>'/financialyear/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }

   public function changedefault(Request $request)
   {
       if ($request->ajax())
       {
            $data  = array('is_default' => $request->status );
            $count = AccountBank::where(['is_default' => $request->status,'account_id'=> $request->account])->count();

            if ($count > 0 && $request->status == 1) {
                return response()->json([
                    'success' => false,
                    'message' => ['There is already a default Account Bank!'],
                    'data'    => []
                ]);
            }

           $Update = AccountBank::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Account Bank default status successfully change'],
                   'data'=>[
                       'redirect'=>'/financialyear/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change default status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }
}
