<?php

namespace App\Http\Controllers\Accounts;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AccountImage;

class AccountImagesController extends Controller
{
    function __construct()
    {
        
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        return view('account-images.create', compact('id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'account_id' => 'required',
            'file'       => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method',
            'file'
        ]);

        $image = AccountImage::where('account_id', $request->account_id)->first();
        $old_image = $image->image ?? '';

        if ($request->hasFile('file')) {
            $path     = 'account-images/' . date('Y') . '/' . date('M');
            $response = uploadImage($path,$request->file,$old_image);

            if ($response['status'] == true) {
                $data['image'] = $response['file_name'];
            } else {
                if ($request->ajax()) {
                    return response()->json([
                        'success' => false,
                        'message' => $response['message'],
                        'data'    => []
                    ]);
                }
                return redirect()->back()->with('error', $response['message']);
            }
        }

        if (!$image) {
            AccountImage::create($data);
        } else {
            $image->update(['image' => $data['image']]);
        }

        return redirect()->back()
            ->with('success','Account Image uploaded successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $image = AccountImage::find($id);

        return view('account-images.edit', compact('image'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'file'  => 'required|mimes:jpg,jpeg,png,doc,docx,pdf',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method',
            'file'
        ]);

        $image = AccountImage::find($id);

        if (!$image) {
            return redirect()->back()
                ->with('error','Address Attachment not found!');
        }
        $old_image = $image->image ?? '';

        if ($request->hasFile('file')) {
            $path     = 'account-images/' . date('Y') . '/' . date('M');
            $response = uploadImage($path,$request->file,$old_image);

            if ($response['status'] == true) {
                $data['image'] = $response['file_name'];
            } else {
                if ($request->ajax()) {
                    return response()->json([
                        'success' => false,
                        'message' => $response['message'],
                        'data'    => []
                    ]);
                }
                return redirect()->back()->with('error', $response['message']);
            }
        }

        $image->update($data);

        return redirect()->back()
            ->with('success','Account image updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $image = AccountImage::find($request->id);

        deleteImage($image->image);

        $image->delete();

        $Redirect = 'accounts';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data'    => [
                'reload' => true,
            ]
        ]);
    }
}
