<?php

namespace App\Http\Controllers\Accounts;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AccountLicense;
use App\Models\LicenseType;

class AccountLicensesController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:license-list', ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //AccountLicense
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $types = LicenseType::select(['id','name'])->where('status', 1)->orderBy('priority','ASC')->get();

        return view('account-licenses.create', compact('id','types'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'license_type_id' => 'required',
            'account_id'      => 'required',
            'license_number'  => 'required',
            'valid_from'      => 'required',
            'valid_upto'      => 'required'
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);
        $data['valid_from'] = $request->valid_from != '' ? date('Y-m-d', strtotime($request->valid_from)) : '';
        $data['valid_upto'] = $request->valid_upto != '' ? date('Y-m-d', strtotime($request->valid_upto)) : '';

        AccountLicense::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Account License has been created successfully',
            ]);
        }
        return redirect()->back()
            ->with('success','Account License has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $license = AccountLicense::find($id);
        $types   = LicenseType::select(['id','name'])->where('status', 1)->get();

        return view('account-licenses.edit', compact('license','types'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'license_type_id' => 'required',
            'license_number'  => 'required',
            'valid_from'      => 'required',
            'valid_upto'      => 'required'
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);
        $data['valid_from'] = $request->valid_from != '' ? date('Y-m-d', strtotime($request->valid_from)) : '';
        $data['valid_upto'] = $request->valid_upto != '' ? date('Y-m-d', strtotime($request->valid_upto)) : '';

        $type = AccountLicense::find($id);

        if (!$type) {
            return redirect()->back()
                ->with('error','Address License not found!');
        }

        $type->update($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Account License has been updated successfully',
            ]);
        }
        return redirect()->back()
            ->with('success','Account License has been updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        AccountLicense::find($request->id)->delete();

        $Redirect = 'accounts';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data'    => [
                'reload' => true,
            ]
        ]);
    }

    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('status' => $request->status );
            $Update = AccountLicense::where('id', '=', $request->id)->update($data);

            if($Update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Address License status successfully change'],
                    'data'=>[
                       'reload'=>true,
                    ]
                ]);
            } else {
                return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
                ]);
            }
        }
    }
}
