<?php

namespace App\Http\Controllers;

use App\Models\Company;
use Illuminate\Http\Request;
use App\Models\Bucket;

class BucketController extends Controller
{
    function __construct()
    {
         // $this->middleware('permission:bucket-list|bucket-create|bucket-edit|bucket-delete', ['only' => ['index','store']]);
         // $this->middleware('permission:bucket-create', ['only' => ['create','store']]);
         // $this->middleware('permission:bucket-edit', ['only' => ['edit','update']]);
         // $this->middleware('permission:bucket-delete', ['only' => ['destroy']]);
    }
    public function index(Request $request)
    {
        $bucketData = Bucket::Select(['bucket_name','id','user_id','root_folder','access_key','secret_key','region','acl','status'])->paginate(10);
        if ($request->ajax()) {
            $sort_by = $request->get('sortby');
            $sort_type = $request->get('sorttype');
            $query = $request->get('query');
            if(!empty($query) && !empty($sort_by) && $query!=" ")
            {
              $bucketData = Bucket::query()->Select(['bucket_name','id','user_id','root_folder','access_key','secret_key','region','acl','status'])->where('bucket_name', 'like', '%'.$query.'%')->paginate($sort_by);
            }
            elseif($sort_by)
            {
              $bucketData = Bucket::Select(['bucket_name','id','user_id','root_folder','access_key','secret_key','region','acl','status'])->paginate($sort_by);
            }
            else
            {
              $bucketData = Bucket::Select(['bucket_name','id','user_id','root_folder','access_key','secret_key','region','acl','status'])->paginate(10);
            }
                        
          return view('bucket.table', compact('bucketData'));
          }
          else
          {
            return view('bucket.index',compact('bucketData'));
          }
    }
    
    public function create()
    {
      $data['companyData']=Company::Select(['id','name'])->get();
        return view('bucket.create',$data);
    }

    public function store(Request $request)
    {
         $input = $request->all();
          Bucket::create($input);
          return redirect()->route('buckets.index')
                        ->with('success','Bucket created successfully');
    }

    public function edit($id,Request $request)
    {
        $bucketData=Bucket::find($id);
        $companyData=Company::Select(['id','name'])->get();
        return view('bucket.edit',compact('bucketData','companyData'));
    }


     public function update($id,Request $request)
     {
        $input = $request->all();
        $bucketData=Bucket::find($id);
        $bucketData->update($input);
        return redirect('buckets')->with('success','Bucket updated successfully');
     }


     public function delete(Request $request)
  {
    $buckets=Bucket::find($request->id);   
        $buckets->delete();
       $Redirect = 'buckets';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);  
  }

   public function changeStatus(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = Bucket::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Bucket status successfully change'],
                   'data'=>[
                       'redirect'=>'/buckets/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }
}
