<?php

namespace App\Http\Controllers;

use App\Models\FinancialYear;
use App\Models\InvoiceSerialSetting;
use Illuminate\Http\Request;

class InvoiceSerialSettingController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:invoice-serial-setting-list', ['only' => ['index']]);
    }

    public function index(Request $request)
    {
      $InvoiceSerialSetting = InvoiceSerialSetting::with('getFinancialYear')->paginate(10);
    //   dd($InvoiceSerialSetting);
        if ($request->ajax()) {
            $sort_by = $request->get('sortby');
            $sort_type = $request->get('sorttype');
            $query = $request->get('query');
            if(!empty($query) && !empty($sort_by) && $query!=" ")
            {
              $InvoiceSerialSetting = InvoiceSerialSetting::query()->with('getFinancialYear')->where('module_type', 'like', '%'.$query.'%')->paginate($sort_by);
            }
            elseif($sort_by)
            {
              $InvoiceSerialSetting = InvoiceSerialSetting::with('getFinancialYear')->paginate($sort_by);
            }
            else
            {
              $InvoiceSerialSetting = InvoiceSerialSetting::with('getFinancialYear')->paginate(10);
            }
            //dd(DB::getQueryLog());

          return view('invoice-serial-setting.table', compact('InvoiceSerialSetting'));
        }
        else
        {
          return view('invoice-serial-setting.index',compact('InvoiceSerialSetting'));
        }

    }

    public function create()
    {
        $data['financialyears']=FinancialYear::select(['financialyearid','financial_year_name'])->latest('financialyearid')->get();
        return view('invoice-serial-setting.add',$data);
    }


    public function store(Request $request)
    {
        $request->validate([
            'module_type' => 'required|unique:invoice_serial_settings',
            'prefix' => 'required',
            'startfrom' => 'required',
            'financial_id'=>'required'
        ]);
        $input = $request->all();
        InvoiceSerialSetting::create($input);
        return redirect('invoice-setting')->with('success','Invoice Serial Setting created successfully.');


    }
   public function edit($id)
   {
    $InvoiceSerialSetting=InvoiceSerialSetting::find($id);
    $data['financialyears']=FinancialYear::select(['financialyearid','financial_year_name'])->latest('financialyearid')->get();
      if($InvoiceSerialSetting =='')
      {
        return redirect('invoice-setting')
        ->with('error',"Inoice Serial is Not Avaiable");
      }
      else
      {
        $data['InvoiceSerialSetting']=$InvoiceSerialSetting;
       return view('invoice-serial-setting.edit',$data);
      }
   }

   public function update($id,Request $request)
   {
      $input = $request->all();
      $InvoiceSerial=InvoiceSerialSetting::find($id);
      $InvoiceSerial->update($input);
      return redirect('invoice-setting')->with('success','Inoice Serial updated successfully');
   }
  public function delete(Request $request)
  {
    $InvoiceSerialSetting=InvoiceSerialSetting::find($request->id);
        $InvoiceSerialSetting->delete();
        $Redirect = 'invoice-setting';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
  }
}
