<?php

namespace App\Http\Controllers\IpdAdmission;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\NurseNote;
use App\Models\IpdAdmission;
use App\Models\NurseNotesComment;
use App\Models\User;


class NurseNotesController extends Controller
{
  
    function __construct()
    {
        $this->middleware('permission:nurse-notes-list',   ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, $id)
    {

        $data = NurseNote::select(
                'nurse_notes.*',
                'users.name as user',
                )
            ->leftjoin('users','users.id','nurse_notes.user_id')
            ->where('nurse_notes.ipd_id',$id)
            ->with('comments','comments.user');
         
            

        if ($request->ajax()) {
            $sort_by      = $request->get('sortby') ?? 10;
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $data = $data->when(!empty($search_query), function ($query) use ($search_query) {
                        return $query->where('note', 'like', '%'.$search_query.'%');
                    })
            ->paginate($sort_by);

            return view('nurse-notes.table', compact('data','id'));
        }
        else
        {
            $data = $data->paginate(10);
            return view('nurse-notes.index',compact('data' ,'id'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        return view('nurse-notes.create', compact('id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request ,$id)
    {
        $validator = \Validator::make($request->all(), [
            'note'     => 'required',
            'comment'    => 'required',
           
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }
        $date = date('Y-m-d H:i:s', strtotime($request->date));

        $data = [
            'note'     => $request->note,
            'comment'  => $request->comment,
            'date'     => $date,
            'user_id'  => \Auth::user()->id,
            'ipd_id'  => $id,
        ];

        $type = NurseNote::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Nurse Note created successfully',
                'data'    => $type
            ]);
        }

        return redirect()->route('nurse-notes.index')
            ->with('success','Nurse Note created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $type      = NurseNote::find($id);

        return view('nurse-notes.edit',compact('type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request ,$id)
    {
        $validator = \Validator::make($request->all(), [
            'note'     => 'required|unique:nurse_notes,note,'.$id,
            'comment'     => 'required|unique:nurse_notes,comment,'.$id,
      
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }
       
        $data = $request->except([
            '_token',
            '_method',
            'date',
        ]);

        $data['date'] = date('Y-m-d H:i:s', strtotime($request->date));
        $type = NurseNote::find($id);

        if (!$type) {
            return redirect()->route('nurse-notes.index')
                ->with('error','Nurse Note not found!');
        }
      
        $type->update($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Nurse Note updated successfully',
                'data'    => $type
            ]);
        }

        return redirect()->route('nurse-notes.index')
            ->with('success','Nurse Note updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        
        NurseNote::find($request->id)->delete();

        $Redirect = 'nurse-notes';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data'    => [
                'redirect' => $Redirect,
            ]
        ]);
    }

     public function createcomment()
    {
        return view('nurse-notes.createcomment');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storecomment(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'comment'    => 'required',
           
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = [
            
            'comment'  => $request->comment,
            'user_id'  => \Auth::user()->id,
            'nurse_note_id'  =>$request->note_id,
        ];

        $type = NurseNotesComment::create($data);

         if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Nurse Note created successfully',
                'data'    => $type
            ]);
        }

        return redirect()->route('nurse-notes.index')
            ->with('success','Nurse Note created successfully');
    }
   public function destroycomment(Request $request)
    {
        
        NurseNotesComment::find($request->id)->delete();

        $Redirect = 'nurse-notes';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data'    => [
                'redirect' => $Redirect,
            ]
        ]);
    }
    

    
}
