<?php

namespace App\Http\Controllers\LibrarySetting;

use App\Http\Controllers\Controller;
use App\Http\Requests\LibrarySetting\BookClassRequest;
use App\Models\LibrarySetting\BookClass;
use Illuminate\Http\Request;

class BookClassController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:library-classes-list|library-classes-create|library-classes-edit|library-classes-delete', ['only' => ['index', 'store', 'list']]);
    }

    public function index(Request $request)
    {
        $datas = BookClass::select(['id', 'class_name', 'class_no', 'status', 'code']);
        $sort_by    = $request->get('sortby') ?? 10;
        $sort_type  = $request->get('sorttype');
        $query      = $request->get('query');
        if (!empty($query) && !empty($sort_by) && $query != " ") {
            $datas->where('class_name', 'like', '%' . $query . '%');
        }
        $data = $datas->orderBy('id', 'desc')->paginate($sort_by);
        if ($request->ajax()) {
            return view('library-setting.bookclasses.table', compact('data'));
        } else {
            return view('library-setting.bookclasses.index', compact('data'));
        }
    }

    public function create()
    {
        return view('library-setting.bookclasses.create');
    }


    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'class_name' => 'required|unique:library_book_classes',
            'code'       => 'required',
            'class_no'   => 'required|unique:library_book_classes'
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token']);

        $data = BookClass::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Book Classes created successfully',
                'data' => $data
            ]);
        }

        return redirect()->route('book_classes.index')
            ->with('success', 'Book Classes created successfully');
    }
    public function edit($id)
    {
        $bookclass         = BookClass::find($id);
        $data['bookclass'] = $bookclass;
        return view('library-setting.bookclasses.edit', $data);
    }

    public function update($id, Request $request)
    {

        $validator = \Validator::make($request->all(), [
            'class_name' => 'required',
            'class_no'   => 'required',
            'code'       => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token', '_method']);
        $data = BookClass::whereId($id)->update($data);
        $data = BookClass::find($id);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Book Class updated successfully',
                'data' => $data
            ]);
        }
        return redirect()->route('book_classes.index')
            ->with('success', 'Book Class updated successfully');
    }



    public function changestatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = BookClass::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Book Classes status successfully change'],
                    'data' => [
                        'redirect' => '/library/book_classes/',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }


    public function destroy(Request $request)
    {
        $editor = BookClass::find($request->id);
        $editor->delete();
        $Redirect = '/library/book_classes/';
        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
