<?php

namespace App\Http\Controllers\LibrarySetting;

use App\Http\Controllers\Controller;
use App\Http\Requests\LibrarySetting\BookFormatesRequest;
use App\Models\LibrarySetting\BookFormates;
use Illuminate\Http\Request;

class BookFormatesController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:library-formates-list|library-formates-create|library-formates-edit|library-formates-delete', ['only' => ['index','store','list']]);
    }

    public function index(Request $request)
    {
      $datas     = BookFormates::select(['id','formate_name','status','code']);
      $sort_by   = $request->get('sortby') ?? 10;
      $sort_type = $request->get('sorttype');
      $query     = $request->get('query');

      if(!empty($query) && !empty($sort_by) && $query != " ")
      {
         $datas->where('formate_name', 'like', '%'.$query.'%');
      }

      $data = $datas->orderBy('id','desc')->paginate($sort_by);

      if ($request->ajax()) {

        return view('library-setting.book_formates.table', compact('data'));
      }
      else
      {
          return view('library-setting.book_formates.index',compact('data'));
      }
    }

    public function create()
    {
        return view('library-setting.book_formates.create');
    }


    public function store(Request $request)
    {

        $validator = \Validator::make($request->all(), [
            'formate_name' => 'required|unique:librarian_book_formates',
            'code'         => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token']);

        $data = BookFormates::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Book Formats created successfully',
                'data' => $data
            ]);
        }

        return redirect()->route('book_formats.index')
            ->with('success', 'Book Formats created successfully');


    }
   public function edit($id)
   {
        $bookformate=BookFormates::find($id);
        $data['bookformate']=$bookformate;
        return view('library-setting.book_formates.edit',$data);
   }

   public function update($id,Request $request)
   {
      $validator = \Validator::make($request->all(), [
        'formate_name' => 'required'
    ]);

      if ($validator->fails()) {
          if ($request->ajax()) {
              return response()->json([
                  'success' => false,
                  'message' => $validator->getMessageBag()->first(),
                  'data'    => []
              ]);
          }

          return redirect()->back()->with('error', $validator->getMessageBag()->first());
      }

      $data = $request->except(['_token', '_method']);
      $data = BookFormates::whereId($id)->update($data);
      $data = BookFormates::find($id);

      if ($request->ajax()) {
          return response()->json([
              'success' => true,
              'message' => 'Book Formats updated successfully',
              'data' => $data
          ]);
      }
      return redirect()->route('book_formats.index')
          ->with('success', 'Book Formats updated successfully');
   }



   public function changestatus(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = BookFormates::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Book Formats status successfully change'],
                   'data'=>[
                       'redirect'=>'/library/book_formats/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }


  public function destroy(Request $request)
  {
        $editor=BookFormates::find($request->id);
        $editor->delete();
       $Redirect = '/library/book_formats/';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
  }
}
