<?php

namespace App\Http\Controllers\LibrarySetting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\LibrarySetting\CardType;

class CardTypeController extends Controller
{
  function __construct()
  {
    $this->middleware('permission:card-type-list|card-type-create|card-type-edit|card-type-delete', ['only' => ['index','store','list']]);
  }

    protected $select=['id','name','book_limit','library_card_serial','card_no_length','serial_start_from',
                        'prefix_code','suffix_code','status'];
    public function index(Request $request)
    {
        $CardTypeData = CardType::select($this->select)->latest('id')->paginate(10);
        if($request->ajax()) {
            $sort_by = $request->get('sortby');
            $sort_type = $request->get('sorttype');
            $query = $request->get('query');
            if(!empty($query) && !empty($sort_by) && $query!=" ")
            {
              $CardTypeData = CardType::query()->select($this->select)->where('name', 'like', '%'.$query.'%')
              ->latest('id')
              ->paginate($sort_by);
            }
            elseif($sort_by)
            {
              $CardTypeData = CardType::select($this->select)->latest('id')->paginate($sort_by);
            }
            else
            {
              $CardTypeData = CardType::select($this->select)->latest('id')->paginate(10);
            }

          return view('library-setting.card-type.table', compact('CardTypeData'));
        }
        else
        {
            return view('library-setting.card-type.index',compact('CardTypeData'));
        }

    }

    public function create()
    {
        return view('library-setting.card-type.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:card_types',
        ]);
        $InsertSubject = $request->all();
        CardType::create($InsertSubject);

        return redirect('library/card-type/')->with('success','Card Type created successfully.');


    }
   public function edit($id)
   {
        $cardType=CardType::find($id);
        $data['cardType']=$cardType;
        return view('library-setting.card-type.edit',$data);
   }

   public function update($id,Request $request)
   {
      $CardType=CardType::find($id);
      $UpdateCardType = $request->all();
      $CardType->update($UpdateCardType);

      return redirect('library/card-type/')->with('success','Card Type updated successfully');
   }


   public function changestatus(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = CardType::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['status successfully change'],
                   'data'=>[
                       'redirect'=>'/library/book_formats/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }

  public function destroy(Request $request)
  {
        $cardType=CardType::find($request->id);
        $cardType->delete();
       $Redirect = '/library/card-type';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
  }
}
