<?php

namespace App\Http\Controllers\LibrarySetting;

use App\Http\Controllers\Controller;
use App\Http\Requests\LibrarySetting\FloorRequest;
use App\Models\LibrarySetting\Floors;
use Illuminate\Http\Request;

class FloorsController extends Controller
{
    public function index(Request $request)
    {
      $data = Floors::select(['id','floor_name','status'])->orderBy('id','desc')->paginate(10);
        if ($request->ajax()) {
            $sort_by = $request->get('sortby');
            $sort_type = $request->get('sorttype');
            $query = $request->get('query');
            if(!empty($query) && !empty($sort_by) && $query!=" ")
            {
              $data = Floors::query()->select(['id','floor_name','status'])->where('floor_name', 'like', '%'.$query.'%')->orderBy('id','desc')->paginate($sort_by);
            }
            elseif($sort_by)
            {
              $data = Floors::select(['id','floor_name','status'])->orderBy('id','desc')->paginate($sort_by);
            }
            else
            {
              $data = Floors::select(['id','floor_name','status'])->orderBy('id','desc')->paginate(10);
            }
                        
          return view('librarian.floors.table', compact('data'));
        }
        else
        {
            return view('librarian.floors.index',compact('data'));
        }
        
    }

    public function create()
    {
        return view('librarian.floors.create');
    }


    public function store(FloorRequest $request)
    {
        $request->validated();
        $input = $request->all();
        Floors::create($input);
        return redirect('library/floors/')->with('success','Floors created successfully.');

        
    }
   public function edit($id)
   {
        $floors=Floors::find($id);
        $data['floors']=$floors;
        return view('librarian.floors.edit',$data);
   }

   public function update($id,Request $request)
   {
      $input = $request->all();
      $genres=Floors::find($id);
      $genres->update($input);
      return redirect()->route('floors.index')->with('success','Floors updated successfully');
   }

   public function changeStatus(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = Floors::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Floors status successfully change'],
                   'data'=>[
                       'redirect'=>'/library/floors/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }


    
  public function delete(Request $request)
  {
        $genres=Floors::find($request->id);   
        $genres->delete();
       $Redirect = '/library/floors/';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);  
  }
}
