<?php

namespace App\Http\Controllers\LibrarySetting;

use App\Http\Controllers\Controller;
use App\Http\Requests\LibrarySetting\BookLanguagessRequest;
use App\Models\LibrarySetting\LibrarianBookLanguages;
use Illuminate\Http\Request;

class LibrarianBookLanguagesController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:library-lanuguages-list|library-lanuguages-create|library-lanuguages-edit|library-lanuguages-delete', ['only' => ['index','store','list']]);
    }

    public function index(Request $request)
    {
      $datas = LibrarianBookLanguages::select(['id','lang_name','lang_code','isfeatured','status','website_view']);
      $sort_by    = $request->get('sortby') ?? 10;
      $sort_type  = $request->get('sorttype');
      $query      = $request->get('query');

      if(!empty($query) && !empty($sort_by) && $query!=" ")
      {
         $datas->where('lang_name', 'like', '%'.$query.'%');
      }
      $data =$datas->orderBy('id','desc')->paginate($sort_by);
        if ($request->ajax()) {
          return view('library-setting.book-languages.table', compact('data'));
        }
        else
        {
            return view('library-setting.book-languages.index',compact('data'));
        }

    }

    public function create()
    {
        return view('library-setting.book-languages.create');
    }


    public function store(BookLanguagessRequest $request)
    {
        $request->validated();
        $input = $request->all();

         /***** Small Cover Image Upload *****/
        $path="library/booklanguages/cover_image_small";
          if(isset($request->cover_image_small))
          {
            $input['cover_image_small']=uploadImage($path,$request->cover_image_small);
          }
          else
          {
            $input['cover_image_small']="";
          }
          /************Large Cover Image Upload ******/
          $path1="library/booklanguages/cover_image_large";
          if(isset($request->cover_image_large))
          {
            $input['cover_image_large']=uploadImage($path1,$request->cover_image_large);
          }
          else
          {
            $input['cover_image_large']="";
          }
        $input['isfeatured']=($request->isfeatured=="on")?'1':'0';
        $input['website_view']=($request->website_view=="on")?'1':'0';
        $data = LibrarianBookLanguages::create($input);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Book Languages created successfully',
                'data' => $data
            ]);
        }

        return redirect('library/book-languages/')->with('success','Book Languages created successfully.');


    }
   public function edit($id)
   {
        $booklanguages=LibrarianBookLanguages::find($id);
        $data['booklanguages']=$booklanguages;
        return view('library-setting.book-languages.edit',$data);
   }

   public function update($id,Request $request)
   {
      $input = $request->all();
      $booklanguages=LibrarianBookLanguages::find($id);
      /***** Small Cover Image Upload *****/
      $path="library/booklanguages/cover_image_small";
      if(isset($request->cover_image_small))
      {
        $input['cover_image_small']=uploadImage($path,$request->logo);
      }
      else
      {
        $input['cover_image_small']=$booklanguages->cover_image_small;
      }
      /************Large Cover Image Upload ******/
      $path1="library/booklanguages/cover_image_large";
      if(isset($request->cover_image_large))
      {
        $input['cover_image_large']=uploadImage($path1,$request->logo);
      }
      else
      {
        $input['cover_image_large']=$booklanguages->cover_image_large;
      }
    $input['isfeatured']=($request->isfeatured=="on")?'1':'0';
    $input['website_view']=($request->website_view=="on")?'1':'0';
      $booklanguages->update($input);
      return redirect('library/book-languages/')->with('success','Book Languages updated successfully');
   }


public function changestatus(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = LibrarianBookLanguages::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Book Languages status successfully change'],
                   'data'=>[
                       'redirect'=>'/library/book-languages/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }

   public function changeisfeatured(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('isfeatured' => $request->status );
           $Update = LibrarianBookLanguages::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Book Languages isfeatured successfully change'],
                   'data'=>[
                       'redirect'=>'/library/book-languages/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }

    public function changewebsiteview(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('website_view' => $request->status );
           $Update = LibrarianBookLanguages::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Book Languages Website view successfully change'],
                   'data'=>[
                       'redirect'=>'/library/book-languages/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }

  public function delete(Request $request)
  {
        $booklanguages=LibrarianBookLanguages::find($request->id);
        $booklanguages->delete();
       $Redirect = '/library/book-languages/';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
  }
}
