<?php

namespace App\Http\Controllers\LibrarySetting;

use App\Http\Controllers\Controller;
use App\Http\Requests\LibrarySetting\TagsRequest;
use App\Models\LibrarySetting\LibrarianTags;
use Illuminate\Http\Request;

class LibrarianTagsController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:library-tags-list|library-tags-create|library-tags-edit|library-tags-delete', ['only' => ['index','store','list']]);
    }

    public function index(Request $request)
    {
      $datas = LibrarianTags::select(['id','tag_name','status']);
      $sort_by    = $request->get('sortby') ?? 10;
      $sort_type  = $request->get('sorttype');
      $query      = $request->get('query');
      if(!empty($query) && !empty($sort_by) && $query!=" ")
      {
         $datas->where('tag_name', 'like', '%'.$query.'%');
      }
      $data =$datas->orderBy('id','desc')->paginate($sort_by);
        if ($request->ajax()) {
          return view('library-setting.tags.table', compact('data'));
        }
        else
        {
            return view('library-setting.tags.index',compact('data'));
        }

    }

    public function create()
    {
        return view('library-setting.tags.create');
    }


    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), ['tag_name' => 'required|unique:librarian_book_tags']);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token']);

        $data = LibrarianTags::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Tag created successfully',
                'data' => $data
            ]);
        }

        return redirect()->route('tags.index')
            ->with('success', 'Tag created successfully');


    }
   public function edit($id)
   {
        $tags=LibrarianTags::find($id);
        $data['tags']=$tags;
        return view('library-setting.tags.edit',$data);
   }

   public function update($id,Request $request)
   {

      $validator = \Validator::make($request->all(), ['tag_name' => 'required']);

      if ($validator->fails()) {
          if ($request->ajax()) {
              return response()->json([
                  'success' => false,
                  'message' => $validator->getMessageBag()->first(),
                  'data'    => []
              ]);
          }

          return redirect()->back()->with('error', $validator->getMessageBag()->first());
      }

      $data = $request->except(['_token', '_method']);
      $data = LibrarianTags::whereId($id)->update($data);
      $data = LibrarianTags::find($id);

      if ($request->ajax()) {
          return response()->json([
              'success' => true,
              'message' => 'Tag updated successfully',
              'data' => $data
          ]);
      }
      return redirect()->route('library-tags.index')
          ->with('success', 'Tag updated successfully');
   }

   public function changestatus(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = LibrarianTags::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Tag status successfully change'],
                   'data'=>[
                       'redirect'=>'/library/library-tags',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }


  public function destroy(Request $request)
  {
        $tags=LibrarianTags::find($request->id);
        $tags->delete();
       $Redirect = '/library/library-tags/';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
  }
}
