<?php

namespace App\Http\Controllers\LibrarySetting;

use App\Http\Controllers\Controller;
use App\Models\LibrarySetting\LibraryStreamSubject;
use App\Models\LibrarySetting\Stream;
use Illuminate\Http\Request;

class LibraryStreamSubjectController extends Controller
{
    public function index(Request $request)
    {
      $streamSubject = LibraryStreamSubject::with('getStreamName')->select(['id','library_stream_id','subject','status'])->orderBy('id','desc')->paginate(10);
        if ($request->ajax()) {
            $sort_by = $request->get('sortby');
            $sort_type = $request->get('sorttype');
            $query = $request->get('query');
            if(!empty($query) && !empty($sort_by) && $query!=" ")
            {
              $streamSubject = LibraryStreamSubject::query()->with('getStreamName')->select(['id','library_stream_id','subject','status'])->where('subject', 'like', '%'.$query.'%')->orderBy('id','desc')->paginate($sort_by);
            }
            elseif($sort_by)
            {
              $streamSubject = LibraryStreamSubject::with('getStreamName')->select(['id','library_stream_id','subject','status'])->orderBy('id','desc')->paginate($sort_by);
            }
            else
            {
              $streamSubject = LibraryStreamSubject::with('getStreamName')->select(['id','library_stream_id','subject','status'])->orderBy('id','desc')->paginate(10);
            }
                        
          return view('librarian.streamsubject.table', compact('streamSubject'));
        }
        else
        {
            return view('librarian.streamsubject.index',compact('streamSubject'));
        }
        
    }

    public function create()
    {
      $stream=Stream::all();
      return view('librarian.streamsubject.create',compact('stream'));
    }


    public function store(Request $request)
    {
        $input = $request->all();
        LibraryStreamSubject::create($input);
        return redirect('library/subject/')->with('success','Subject created successfully.');   
    }
   public function edit($id)
   {
        $data['streamSubject']=LibraryStreamSubject::find($id);
        $stream=Stream::all();
        $data['stream']=$stream;
        return view('librarian.streamsubject.edit',$data);
   }

   public function update($id,Request $request)
   {
      $input = $request->all();
      $stream=LibraryStreamSubject::find($id);
      $stream->update($input);
      return redirect('library/subject/')->with('success','Subject updated successfully');
   }

   public function changeStatus(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = LibraryStreamSubject::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Subject status successfully change'],
                   'data'=>[
                       'redirect'=>'/library/subject/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }
  public function delete(Request $request)
  {
        $genres=LibraryStreamSubject::find($request->id);   
        $genres->delete();
       $Redirect = '/library/subject/';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);  
  }
}
