<?php

namespace App\Http\Controllers\LibrarySetting;

use App\Http\Controllers\Controller;
use App\Models\LibrarySetting\MembershipPlan;
use Illuminate\Http\Request;

class MembershipPlanController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:membership-plan-list|membership-plan-create|membership-plan-edit|membership-plan-delete', ['only' => ['index','store','list']]);
    }

    public function index(Request $request)
    {
      $datas      = MembershipPlan::select(['id','name','details','fees','fees_plan','book_limit','book_validity','status','priority']);
      $sort_by    = $request->get('sortby') ?? 10;
      $sort_type  = $request->get('sorttype');
      $query      = $request->get('query');
      if(!empty($query) && !empty($sort_by) && $query!=" ")
      {
         $datas->where('name', 'like', '%'.$query.'%');
      }
      $MembershipPlan =$datas->orderBy('id','desc')->paginate($sort_by);

        if ($request->ajax()) {
          return view('library-setting.membership-plan.table', compact('MembershipPlan'));
        }
        else
        {
            return view('library-setting.membership-plan.index',compact('MembershipPlan'));
        }

    }
    public function create()
    {
        $priority = MembershipPlan::max('priority');
        $priority = $priority != '' ? $priority : 0;

        return view('library-setting.membership-plan.create', compact('priority'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'book_limit' => 'required',
            'book_validity' => 'required',
        ]);
        $InsertData=$request->all();
        MembershipPlan::create($InsertData);
        return redirect('library/membership-plan')->with('success','Membership Plan Create successfully');

    }
    public function edit($id,Request $request)
    {
        $data['MembershipPlan']=MembershipPlan::find($id);
        return view('library-setting.membership-plan.edit',$data);
    }

    public function update($id,Request $request)
    {

      $request->validate([
        'name' => 'required',
        'book_limit' => 'required',
        'book_validity' => 'required',
    ]);
        $MembershipPlan=MembershipPlan::find($id);
        $InsertData=$request->all();
        $MembershipPlan->update($InsertData);
        return redirect('library/membership-plan')->with('success','Membership Plan Updated successfully');

    }

    public function changeStatus(Request $request)
    {
        if ($request->ajax())
        {
            $data = array('status' => $request->status );
            $Update = MembershipPlan::where('id', '=', $request->id)->update($data);

            if($Update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Membership Plan status successfully change'],
                    'data'=>[
                        'redirect'=>'library/membership-plan',
                        'reload'=>true,
                    ]
                ]);
            }
            else{
                return response()->json([
                    'success'=>false,
                    'message'=>['Error for change status'],
                    'data'=>[
                        'redirect'=>'',
                    ]
                ]);
            }
        }
    }

  public function destroy(Request $request)
  {
        $MembershipPlan=MembershipPlan::find($request->id);
        $MembershipPlan->delete();
        $Redirect = '/library/membership-plan';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
  }
}
