<?php

namespace App\Http\Controllers\LibrarySetting;

use App\Http\Controllers\Controller;
use App\Http\Requests\LibrarySetting\PlacesRequest;
use App\Models\LibrarySetting\Places;
use Illuminate\Http\Request;

class PlacesController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:library-places-list|library-places-create|library-places-edit|library-places-delete', ['only' => ['index','store','list']]);
    }


    public function index(Request $request)
    {
      $datas = Places::select(['id','place','status']);
      $sort_by    = $request->get('sortby') ?? 10;
      $sort_type  = $request->get('sorttype');
      $query      = $request->get('query');
      if(!empty($query) && !empty($sort_by) && $query!=" ")
      {
         $datas->where('place', 'like', '%'.$query.'%');
      }
      $data =$datas->orderBy('id','desc')->paginate($sort_by);
        if ($request->ajax()) {
          return view('library-setting.places.table', compact('data'));
        }
        else
        {
            return view('library-setting.places.index',compact('data'));
        }

    }

    public function create()
    {
        return view('library-setting.places.create');
    }


    public function store(Request $request)
    {

        $validator = \Validator::make($request->all(), ['place' => 'required']);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token']);

        $data = Places::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Places created successfully',
                'data' => $data
            ]);
        }

        return redirect()->route('places.index')
            ->with('success', 'Places created successfully');


    }
   public function edit($id)
   {
        $publishers=Places::find($id);
        $data['publishers']=$publishers;
        return view('library-setting.places.edit',$data);
   }

   public function update($id,Request $request)
   {

      $validator = \Validator::make($request->all(), ['place' => 'required']);

      if ($validator->fails()) {
          if ($request->ajax()) {
              return response()->json([
                  'success' => false,
                  'message' => $validator->getMessageBag()->first(),
                  'data'    => []
              ]);
          }

          return redirect()->back()->with('error', $validator->getMessageBag()->first());
      }

      $data = $request->except(['_token', '_method']);
      $data = Places::whereId($id)->update($data);
      $data = Places::find($id);

      if ($request->ajax()) {
          return response()->json([
              'success' => true,
              'message' => 'Places updated successfully',
              'data' => $data
          ]);
      }
      return redirect()->route('places.index')
          ->with('success', 'Places updated successfully');
   }

public function changestatus(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = Places::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Place status successfully change'],
                   'data'=>[
                       'redirect'=>'/library/places',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }

  public function destroy(Request $request)
  {
        $publishers=Places::find($request->id);
        $publishers->delete();
       $Redirect = '/library/places/';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
  }
}
