<?php

namespace App\Http\Controllers\LibrarySetting;

use App\Http\Controllers\Controller;
use App\Http\Requests\LibrarySetting\SteamsRequest;
use Illuminate\Http\Request;
use App\Models\LibrarySetting\Stream;

class StreamController extends Controller
{
  function __construct()
    {
        $this->middleware('permission:library-stream-list|library-stream-create|library-stream-edit|library-stream-delete', ['only' => ['index','store','list']]);
    }
    public function index(Request $request)
    {
      $datas = Stream::select(['id','stream_name','isfeatured','website_view','status']);
      $sort_by    = $request->get('sortby') ?? 10;
      $sort_type  = $request->get('sorttype');
      $query      = $request->get('query');
      if(!empty($query) && !empty($sort_by) && $query!=" ")
      {
         $datas->where('stream_name', 'like', '%'.$query.'%');
      }
      $data =$datas->orderBy('id','desc')->paginate($sort_by);
        if ($request->ajax()) {
          return view('library-setting.stream.table', compact('data'));
        }
        else
        {
            return view('library-setting.stream.index',compact('data'));
        }

    }

    public function create()
    {
        return view('library-setting.stream.create');
    }


    public function store(SteamsRequest $request)
    {
        $request->validated();
        $input = $request->all();
        /***** Small Cover Image Upload *****/
        $path="library/stream/cover_image_small";
          if(isset($request->cover_image_small))
          {
            $input['cover_image_small']=uploadImage($path,$request->cover_image_small);
          }
          else
          {
            $input['cover_image_small']="";
          }
          /************Large Cover Image Upload ******/
          $path1="library/stream/cover_image_large";
          if(isset($request->cover_image_large))
          {
            $input['cover_image_large']=uploadImage($path1,$request->cover_image_large);
          }
          else
          {
            $input['cover_image_large']="";
          }
        $input['isfeatured']=($request->isfeatured=="on")?'1':'0';
        $input['website_view']=($request->website_view=="on")?'1':'0';
        $data = Stream::create($input);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Stream created successfully',
                'data' => $data
            ]);
        }

        return redirect('library/stream/')->with('success','Stream created successfully.');


    }
   public function edit($id)
   {
        $stream=Stream::find($id);
        $data['stream']=$stream;
        return view('library-setting.stream.edit',$data);
   }

   public function update($id,Request $request)
   {
      $input = $request->all();
      $stream=Stream::find($id);
      /***** Small Cover Image Upload *****/
      $path="library/stream/cover_image_small";
      if(isset($request->cover_image_small))
      {
        $input['cover_image_small']=uploadImage($path,$request->cover_image_small);
      }
      else
      {
        $input['cover_image_small']=$stream->cover_image_small;
      }
      /************Large Cover Image Upload ******/
      $path1="library/stream/cover_image_large";
      if(isset($request->cover_image_large))
      {
        $input['cover_image_large']=uploadImage($path1,$request->cover_image_large);
      }
      else
      {
        $input['cover_image_large']=$stream->cover_image_large;
      }
        $input['isfeatured']=($request->isfeatured=="on")?'1':'0';
        $input['website_view']=($request->website_view=="on")?'1':'0';
      $stream->update($input);
      return redirect('library/stream/')->with('success','Stream updated successfully');
   }

   public function changeStatus(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = Stream::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Stream status successfully change'],
                   'data'=>[
                       'redirect'=>'/library/stream/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }

   public function changeisfeatured(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('isfeatured' => $request->status );
           $Update = Stream::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Stream isfeatured successfully change'],
                   'data'=>[
                       'redirect'=>'/library/stream/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }

    public function changewebsiteview(Request $request)
   {
       if ($request->ajax())
       {
           $data = array('website_view' => $request->status );
           $Update = Stream::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Stream Website view successfully change'],
                   'data'=>[
                       'redirect'=>'/library/stream/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
   }
  public function destroy(Request $request)
  {
        $genres=Stream::find($request->id);
        $genres->delete();
       $Redirect = '/library/stream/';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
  }
}
