<?php

namespace App\Http\Controllers\LicenseManagement;

use App\Http\Controllers\Controller;
use App\Models\Account;
use Illuminate\Http\Request;

class customerListController extends Controller
{
    function __construct()
    {
        // $this->middleware('permission:tax-category-list', ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = Account::select([
            'accounts.id',
            'accounts.name',
            'accounts.code',
            'accounting_groups.name as group_name',
            'account_addresses.address_line1 as address',
            'countries.name as country',
            'states.name as state',
            'cities.name as city',
            'account_contacts.phone_no',
            'account_contacts.email',
        ])
            ->leftjoin('account_contacts', 'account_contacts.account_id', 'accounts.id')
            ->leftjoin('accounting_groups', 'accounting_groups.id', 'accounts.accounting_group_id')
            ->leftjoin('account_addresses', 'account_addresses.account_id', 'accounts.id')
            ->leftjoin('countries', 'countries.id', 'account_addresses.country_id')
            ->leftjoin('states', 'states.id', 'account_addresses.state_id')
            ->leftjoin('cities', 'cities.id', 'account_addresses.city_id')
            ->leftjoin('account_types', 'accounts.account_type_id', 'account_types.id')
            ->where('account_types.type_code', '=', 'CUSTOMER');

        if ($request->ajax()) {
            $sort_by = $request->get('sortby') ?? 10;
            $sort_type = $request->get('sorttype');
            $search_query = $request->get('query');

            $data = $data->when(!empty($search_query), function ($query) use ($search_query) {
                return $query->where('accounts.name', 'like', '%' . $search_query . '%')
                    ->orWhere('accounts.code', 'like', '%' . $search_query . '%');
            })
                ->paginate($sort_by);

            return view('customer-list.table', compact('data'));
        } else {
            $data = $data->paginate(10);

            return view('customer-list.index', compact('data'));
        }
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
