<?php

namespace App\Http\Controllers\MedicalSetting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BodyVital;

class BodyVitalsController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:body-vitals-list', ['only' => ['index']]);
    }

    public function index(Request $request)
    {
        $data = BodyVital::select([
                    'body_vitals.id',
                    'body_vitals.name',
                    'body_vitals.code',
                    'body_vitals.min_value',
                    'body_vitals.max_value',
                    'body_vitals.priority',
                    'body_vitals.status',
                    'body_vitals.mandatory',
                    'body_vitals.unit',
                    'body_vitals.short_name',
                ])
                ->orderBy('priority', 'ASC');

        if ($request->ajax()) {
            $sort_by      = $request->get('sortby') ?? 10;
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $data = $data->when(!empty($search_query), function ($query) use ($search_query) {
                return $query->where('body_vitals.name', 'like', '%'.$search_query.'%')
                    ->orWhere('body_vitals.code', 'like', '%'.$search_query.'%')
                    ->orWhere('body_vitals.min_value', 'like', '%'.$search_query.'%')
                    ->orWhere('body_vitals.max_value', 'like', '%'.$search_query.'%');
            })
            ->orderBy('priority', 'ASC')
            ->paginate($sort_by);

            return view('body-vitals.table', compact('data'));
        }
        else
        {
            $data = $data->paginate(10);

            return view('body-vitals.index', compact('data'));
        }
    }

    public function create()
    {
        $priority = BodyVital::max('priority');
        $priority = $priority != '' ? $priority : 0;

        return view('body-vitals.create',compact('priority'));
    }

    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'name' => 'required|unique:body_vitals,name,NULL,id,deleted_at,NULL',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);

        $BodyVital = BodyVital::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Body vital created successfully.',
                'data'    => $BodyVital
            ]);
        }
    }

    public function edit($id)
    {
        $data = BodyVital::find($id);

        return view('body-vitals.edit', compact('data'));
    }

    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'name' => 'required|unique:body_vitals,name,'.$id.',id,deleted_at,NULL',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);

        $BodyVital = BodyVital::find($id);

        if (!$BodyVital) {
            return redirect()->route('body-vitals.index')
                ->with('error','Body vital not found!');
        }

        $BodyVital->update($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Body vital Updated successfully',
                'data'    => $BodyVital
            ]);
        }
    }

    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('status' => $request->status );
            $Update = BodyVital::where('id', '=', $request->id)->update($data);

            $Redirect = 'body-vitals';

            if($Update){
                return response()->json([
                    'success' => true,
                    'message' => ['Body vital status successfully change'],
                    'data'    => [
                        'redirect' => $Redirect,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data'    => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }

    public function changeMandatoryStatus(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('mandatory' => $request->status );
            $Update = BodyVital::where('id', '=', $request->id)->update($data);

            $Redirect = 'body-vitals';

            if($Update){
                return response()->json([
                    'success' => true,
                    'message' => ['Body vital Mandatory successfully change'],
                    'data'    => [
                        'redirect' => $Redirect,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data'    => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }

    public function destroy(Request $request)
    {
        BodyVital::find($request->id)->delete();

        $Redirect = 'body-vitals';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data'    => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
