<?php

namespace App\Http\Controllers\OpdAppointment;

use App\Http\Controllers\Controller;
use App\Models\AppointmentDoctorShift;
use App\Models\AppointmentDoctorShiftDay;
use App\Models\AppointmentShift;
use App\Models\Doctor;
use Illuminate\Http\Request;

class AppointmentDoctorShiftDaysController extends Controller
{
    function __construct()
    {
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($doctor_id, $shift_id)
    {
        $shift_name  = AppointmentShift::select('name')->where('id', $shift_id)->first();
        $doctor_days = AppointmentDoctorShiftDay::select('*',
                \DB::raw("(GROUP_CONCAT(day_id SEPARATOR ',')) as `days`"),
            )
            ->where('doctor_id', $doctor_id)
            ->where('shift_id', $shift_id)
            ->with('getDoctor')
            ->first();

        return view('appointment-doctor-shift-days.index', compact('doctor_days', 'shift_id', 'doctor_id','shift_name'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store($doctor_id, $shift_id, Request $request)
    {
        $day_ids = $request->day_id ?? [];
        $day_ids = array_keys($day_ids);
        
        $doctor = Doctor::find($doctor_id);

        AppointmentDoctorShiftDay::where('doctor_id', $doctor_id)->where('shift_id', $shift_id)->whereNotIn('day_id', $day_ids)->delete();

        foreach ($day_ids as $day_id) {

            $doctor_days = ([
                'doctor_id'     => $doctor_id,
                'shift_id'      => $shift_id,
                'day_id'        => $day_id,
                'chamber_id'    => $doctor->doctors_chamber_id,
            ]);

            AppointmentDoctorShiftDay::updateOrCreate($doctor_days);
        }

        return redirect()->back()->with('success', '');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function statusActive(Request $request)
    {
        
        $doctor_id = $request->input('doctor_id');
        $shift_id  = $request->input('shift_id');
        $day_id    = $request->input('day_id');
        $status    = $request->input('status');
        $doctor = Doctor::find($doctor_id);

        if ($day_id == "all") {
            if ($status == '0') {
                AppointmentDoctorShiftDay::where('doctor_id', $doctor_id)
                    ->where('shift_id', $shift_id)
                    ->delete();
            } else {

                $day_ids = [
                    '1',
                    '2',
                    '3',
                    '4',
                    '5',
                    '6',
                    '7'
                ];

                foreach ($day_ids as $day_id) {
                    $doctor_days = ([
                        'doctor_id'     => $doctor_id,
                        'shift_id'      => $shift_id,
                        'day_id'        => $day_id,
                        'chamber_id'    => $doctor->doctors_chamber_id,
                    ]);

                    $day = AppointmentDoctorShiftDay::updateOrCreate($doctor_days);
                }
            }
        } else {

            if ($status == '1') {
                AppointmentDoctorShiftDay::updateOrCreate(
                    ['doctor_id' => $doctor_id, 'shift_id' => $shift_id, 'day_id' => $day_id],
                    ['active' => 1]
                );
            } elseif ($status == '0') {
                AppointmentDoctorShiftDay::where('doctor_id', $doctor_id)
                    ->where('shift_id', $shift_id)
                    ->where('day_id', $day_id)
                    ->delete();
            }
        }

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Days Status successfully',
            ]);
        }

        return redirect()->back()->with('success', 'Days Status successfully');
    }
}
