<?php

namespace App\Http\Controllers\OpdAppointment;

use App\Models\Account;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AppointmentShift;
use App\Models\AppointmentDoctorShift;
use App\Models\Doctor;

class AppointmentDoctorShiftsController extends Controller
{
    function __construct()
    {
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        $appointment_shifts = AppointmentShift::select('id', 'name')->where('status', 1)->get();
        $doctor = Doctor::find($id);

        $doctor_shifts = AppointmentDoctorShift::select(
            '*',
            \DB::raw("(GROUP_CONCAT(shift_id SEPARATOR ',')) as `shifts`"),
        )
            ->where('doctor_id', $id)
            ->where('chamber_id',$doctor->doctors_chamber_id)
            ->with('getDoctor')
            ->first();
        return view('appointment-doctor-shifts.index', compact('appointment_shifts', 'doctor_shifts', 'id'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store($id, Request $request)
    {
        $shift_ids = $request->shift_id ?? [];
        $shift_ids = array_keys($shift_ids);

        AppointmentDoctorShift::where('doctor_id', $id)->whereNotIn('shift_id', $shift_ids)->delete();

        $doctor = Doctor::find($id);

        foreach ($shift_ids as $shift_id) {

            $doctor_shift = ([
                'doctor_id'     => $id,
                'shift_id'      => $shift_id,
                'chamber_id'    => $doctor->doctors_chamber_id,
            ]);

            AppointmentDoctorShift::updateOrCreate($doctor_shift);
        }

        return redirect()->back()->with('success', '');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        $shift = AppointmentDoctorShift::find($id);
        return view('appointment-doctor-shifts.edit', compact('shift'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $shifts = AppointmentDoctorShift::find($id);
        $data['patient_quantity'] = $request->patient_quantity;
        $data['time_from']        = $request->time_from;
        $data['time_to']          = $request->time_to;
        $data['serial_start']     = $request->serial_start;
        $shifts->update($data);
        return redirect()->back()->with('success', 'Shift Changed Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function shiftStatus(Request $request)
    {
        $doctor_id = $request->input('id') ?? '';
        $shift_id = $request->input('shift_id') ?? '';
        $status = $request->input('status') ?? '';
        $doctor = Doctor::find($doctor_id);
        if ($shift_id == "all") {
            if ($status == '0') {
                // Delete records with the given doctor_id for all shifts when status is '0'
                AppointmentDoctorShift::where('doctor_id', $doctor_id)->delete();
            } else {
                $shift_ids = AppointmentShift::get();

                foreach ($shift_ids as $shift_id) {
                    AppointmentDoctorShift::updateOrCreate(
                        ['shift_id' => $shift_id->id, 'doctor_id' => $doctor_id],
                        [
                            'status'            => 1,
                            'patient_quantity'  => $shift_id->patient_quantity ? $shift_id->patient_quantity : 25,
                            'time_from'         => $shift_id->time_from ?? '',
                            'time_to'           => $shift_id->time_to ?? '',
                            'chamber_id'        => $doctor->doctors_chamber_id,
                        ]
                    );
                }
            }
        } else {
            if ($status == '1') {
                $shifts = AppointmentShift::find($shift_id);
                AppointmentDoctorShift::updateOrCreate(
                    ['doctor_id' => $doctor_id, 'shift_id' => $shift_id],
                    [
                        'status'            => 1,
                        'patient_quantity'  => $shifts->patient_quantity ? $shifts->patient_quantity : 25,
                        'time_from'         => $shifts->time_from ?? '',
                        'time_to'           => $shifts->time_to ?? '',
                        'chamber_id'        => $doctor->doctors_chamber_id,
                    ]
                );
            } elseif ($status == '0') {
                // Delete records with the given doctor_id and shift_id when status is '0'
                AppointmentDoctorShift::where('doctor_id', $doctor_id)
                    ->where('shift_id', $shift_id)
                    ->delete();
            }
        }

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Shift Status successfully',
            ]);
        }

        return redirect()->back()->with('success', 'Shift Status Changed Successfully');
    }



    public function shiftWebBookingStatus(Request $request)
    {
        $doctor_id = $request->input('id') ?? '';
        $shift_id = $request->input('shift_id') ?? '';
        $status = $request->input('status') ?? '';


        if ($status == '1') {
            // \DB::enableQueryLog();
            AppointmentDoctorShift::updateOrCreate(
                ['doctor_id' => $doctor_id, 'shift_id' => $shift_id],
                ['web_booking' => '1']
            );
            // dd(\DB::getQueryLog());
        } elseif ($status == '0') {
            AppointmentDoctorShift::updateOrCreate(
                ['doctor_id' => $doctor_id, 'shift_id' => $shift_id],
                ['web_booking' => '0']
            );
        }


        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Web Booking Status successfully',
            ]);
        }

        return redirect()->back()->with('success', 'Web Booking Status Changed Successfully');
    }


    public function shiftAppBookingStatus(Request $request)
    {
        $doctor_id = $request->input('id') ?? '';
        $shift_id = $request->input('shift_id') ?? '';
        $status = $request->input('status') ?? '';


        if ($status == '1') {
            // \DB::enableQueryLog();
            AppointmentDoctorShift::updateOrCreate(
                ['doctor_id' => $doctor_id, 'shift_id' => $shift_id],
                ['app_booking' => '1']
            );
            // dd(\DB::getQueryLog());
        } elseif ($status == '0') {
            AppointmentDoctorShift::updateOrCreate(
                ['doctor_id' => $doctor_id, 'shift_id' => $shift_id],
                ['app_booking' => '0']
            );
        }


        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'App Booking Status successfully',
            ]);
        }

        return redirect()->back()->with('success', 'App Booking Status Changed Successfully');
    }
}
