<?php

namespace App\Http\Controllers\OpdAppointment;


use App\Http\Controllers\Controller;
use App\Models\DoctorChamber;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DoctorChamberControllers extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (!$this->checkPermission('doctor-chamber-list')) {
            return redirect()->back()->with('info', 'You don\'t have enough permission to access this page.');
        }

        $data = DoctorChamber::select('*');

        $sort_by        = $request->get('sortby') ?? 10;
        $sort_type      = $request->get('sorttype');
        $search_query   = $request->get('query');
        if (isset($search_query) && $search_query != '') {
            $data = $data->where('name', 'like', '%' . $search_query . '%');
        }

        $data = $data->paginate($sort_by);
        if ($request->ajax()) {
            return view('doctor.chamber.table', compact('data'));
        } else {
            return view('doctor.chamber.index', compact('data'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $priority           = DoctorChamber::max('priority');
        $priority           = $priority != '' ? $priority : 0;
        return view('doctor.chamber.create', compact('priority'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // dd($request->all());
        $validator = \Validator::make($request->all(), [
            'name' => 'required|unique:doctor_chambers',

        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data' => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method',
        ]);

        $default_check = DoctorChamber::where(['is_default' => '1','status' => '1'])->first();

        if (!$default_check) {
            $data['is_default'] = '1';
        }

        $chambers = DoctorChamber::create($data);



        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Chamber Created Successfully',
                'data' => $chambers
            ]);
        }
        return redirect()->route('doctor.index')
            ->with('success', 'Doctor Created Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $chamber = DoctorChamber::find($id);
        return view('doctor.chamber.edit', compact(
            'chamber',
        ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $validator = \Validator::make($request->all(), [
            'name'              => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data' => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method',
        ]);

        $doctorChamber = DoctorChamber::find($id);

        if (!$doctorChamber) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => "Doctor Chamber not found!",
                    'data' => []
                ]);
            }
            return redirect()->back()->with('error', "Doctor  Chamber not found!");
        }

        $doctorChamber->update($data);



        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Doctor Chamber has been created successfully',
            ]);
        }

        return redirect()->route('doctor-chamber.index')
            ->with('success', 'Doctor Chamber updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $about = DoctorChamber::find($request->id);

        if ($about->is_default == '1') {
            return response()->json([
                'success' => false,
                'message' => ['Default record can not be deleted.']
            ]);
        }

        $about->delete();

        $Redirect = 'doctor-chamber';

        return response()->json([
            'success' => true,
            'message' => ['Doctor Chamber Deleted successfully'],
            'data'    => [
                'redirect' => $Redirect,
            ]
        ]);
    }
    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = DoctorChamber::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Chamber status successfully change'],
                    'data' => [
                        'redirect' => '',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }

    public function changeDefault(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('is_default' => $request->status );
            $count  = DoctorChamber::where(['is_default' => $request->status])->count();

            if ($count > 0 && $request->status == 1) {
                return response()->json([
                    'success' => false,
                    'message' => ['There is already a default Task!'],
                    'data'    => []
                ]);
            }

            $Update = DoctorChamber::where('id', '=', $request->id)->update($data);

            if($Update){
                return response()->json([
                    'success'=>true,
                    'message'=>['DoctorChamber default status successfully changed.'],
                    'data'=>[
                       'redirect'=>'/task/',
                       'reload'=>true,
                    ]
                ]);
            } else {
                return response()->json([
                   'success'=>false,
                   'message'=>['Error for change default'],
                   'data'=>[
                       'redirect'=>'',
                   ]
                ]);
            }
        }
    }
}
