<?php

namespace App\Http\Controllers\OpdAppointment;

use App\Models\AppointmentShift;
use App\Models\Doctor;
use App\Models\HolidaySetting;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;

class DoctorHolidaySettingController extends Controller
{
    public function index(Request $request,$id)
    {
        $doctor_id=$id;
        $doctor=Doctor::with('getAccount')->find($id);
        $datas = HolidaySetting::with('getShift')
        ->select('account_id','id', 'from_date','to_date','from_date','shift_id')
                                        ->where('account_id',$id);
        $sort_by    = $request->get('sortby') ?? 10;
        $sort_type  = $request->get('sorttype');
        $query      = $request->get('query');
        if(!empty($query) && !empty($sort_by) && $query!=" ")
        {
            $datas->whereRelation('getShift','name', 'like', '%'.$query.'%');
        } 
        $holiday_shifts =$datas->orderBy('from_date','desc')->paginate($sort_by);
            if ($request->ajax()) {         
            return view('doctor-holiday-shift.table', compact('holiday_shifts','id','doctor_id'));
            }
            else
            {
        
        return view('doctor-holiday-shift.index', compact('holiday_shifts','id','doctor_id','doctor'));
                                          }
    }

    public function create($doctor_id)
    {
        $appointment_shifts = AppointmentShift::select('id', 'name')->where('status',1)->get();
        $doctor=Doctor::with('getAccount')->find($doctor_id);
        return view('doctor-holiday-shift.create', compact('doctor_id','appointment_shifts','doctor'));
    }

    public function store(Request $request,$doctor_id)
    {

        $startDate = date('Y-m-d', strtotime($request->from_date)); // Replace with your start date
        $endDate = date('Y-m-d', strtotime($request->to_date));   // Replace with your end date

        $startDate = Carbon::parse($startDate); // Replace with your start date
        $endDate = Carbon::parse($endDate);   // Replace with your end date
        
        // Calculate the difference in days
        $daysDifference = $endDate->diffInDays($startDate);

        $doctorData = Doctor::find($doctor_id)->first();

        while ($startDate <= $endDate) {

            foreach($request->shift_id as $shift_id)
            {
                $holidayExit=HolidaySetting::where([
                    'from_date'     => $startDate,
                    'to_date'       => $startDate,
                    'account_id'    => $doctor_id,
                    'shift_id'      => $shift_id,
                    'chamber_id'    => $doctorData->doctors_chamber_id
                    ])->first();
                    if(!$holidayExit)
                    {
                        HolidaySetting::create([
                            'from_date'     => $startDate,
                            'to_date'       => $startDate,
                            'account_id'    => $doctor_id,
                            'shift_id'      => $shift_id,
                            'status'        => 1,
                            'chamber_id'    => $doctorData->doctors_chamber_id
                        ]);
                    }
               
            }
        
            // Move to the next day
            $startDate->addDay();
        }

        return redirect()->back()->with('success', '');
    }

    public function edit(Request $request,$id)
    {
        $appointment_shifts = AppointmentShift::select('id', 'name')->where('status',1)->get();
        $settings=HolidaySetting::find($id);
        return view('doctor-holiday-shift.edit', compact('settings','appointment_shifts'));
    }


    public function update(Request $request,$id)
    {

        $startDate = date('Y-m-d', strtotime($request->from_date)); // Replace with your start date
        $endDate = date('Y-m-d', strtotime($request->to_date));   // Replace with your end date

        $startDate = Carbon::parse($startDate); // Replace with your start date
        $endDate = Carbon::parse($endDate);   // Replace with your end date
        
        $settings=HolidaySetting::find($id);

        $doctorData = Doctor::find($settings->account_id)->first();

      
        $settings->update([
                    'from_date'     => $startDate,
                    'to_date'       => $endDate,
                    'shift_id'      => $request->shift_id,
                    'status'        => 1,
                    'chamber_id'    => $doctorData->doctors_chamber_id
                ]);
          

        return redirect()->back()->with('success', '');
    }


    public function destroy(Request $request,$doctor_id)
    {
        HolidaySetting::find($request->id)->delete();

        $Redirect = 'doctor-holiday-shifts';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data'    => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
