<?php

namespace App\Http\Controllers;

use App\Models\MenuModelPermission;
use App\Models\PriceSetting;
use App\Models\VoucherMaster;
use Illuminate\Http\Request;

class PriceSettingController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:price-setting-list', ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = PriceSetting::select([
            'price_settings.id',
            'price_settings.master_voucher_id',
            'price_settings.price_setting'
        ])
        ->with('getVoucherModule');

        if ($request->ajax()) {
            $sort_by      = $request->get('sortby') ?? 10;
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $data = $data->when(!empty($search_query), function ($query) use ($search_query) {
                return $query->whereHas('getVoucherModule', function ($subQuery) use ($search_query) {
                    $subQuery->where('voucher_name', 'like', '%' . $search_query . '%');
                });
            })

            ->paginate($sort_by);

            return view('price-settings.table', compact('data'));
        } else {
            $data = $data->paginate(10);

            return view('price-settings.index', compact('data'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $voucher_master = VoucherMaster::select('id','voucher_name')->where('status','1')->get();
        return view('price-settings.create', compact('voucher_master'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'master_voucher_id'     => 'required',
            'price_setting'         => 'required',
        ],[
            'master_voucher_id.required'    => 'The Voucher Master is required.',
            'price_setting.required'        => 'The Price Setting is required.',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);

        $quality = PriceSetting::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Price Setting created successfully',
                'data'    => $quality
            ]);
        }

        return redirect()->route('price-settings.index')
            ->with('success', 'Price Setting created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $PriceSetting = PriceSetting::find($id);
        $voucher_master = VoucherMaster::select('id','voucher_name')->where('status','1')->get();

        return view('price-settings.edit', compact('PriceSetting', 'voucher_master'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'master_voucher_id'     => 'required',
            'price_setting'         => 'required',
        ],[
            'master_voucher_id.required'    => 'The Voucher Master is required.',
            'price_setting.required'        => 'The Price Setting is required.',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);

        $master = PriceSetting::find($id);

        if (!$master) {
            return redirect()->route('price_setting.index')
                ->with('error','Price Setting not found!');
        }

        $master->update($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Price Setting updated successfully',
                'data'    => $master
            ]);
        }

        return redirect()->route('price_setting.index')
            ->with('success','Price Setting updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        PriceSetting::find($request->id)->delete();

        $Redirect = 'price-settings';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data'    => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}

