<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PrintStyleSetting;

class PrintStyleSettingsController extends Controller
{
    function __construct()
    {
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $company_id = \Auth::user()->company_id ?? '';
        $data       = PrintStyleSetting::where('company_id', $company_id)->first();

        return view('print-style-settings.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->except([
            '_token',
            '_method',
            'watermark',
            'letter_head',
        ]);

        $data['show_header']    = $request->show_header == 'on' ? 1 : 0;
        $data['show_footer']    = $request->show_footer == 'on' ? 1 : 0;
        $data['show_watermark'] = $request->show_watermark == 'on' ? 1 : 0;
        
        $company_id = \Auth::user()->company_id ?? '';
        
        if ($request->hasFile('letter_head')) {
            $path     = 'print-style-settings/' . date('Y') . '/' . date('M');
            $response = uploadImage($path,$request->letter_head);

            if ($response['status'] == true) {
                $data['letter_head'] = $response['file_name'];
            } else {
                return redirect()->back()->with('error', $response['message']);
            }
        }
        
        if ($request->hasFile('watermark')) {
            $path     = 'print-style-settings/' . date('Y') . '/' . date('M');
            $response = uploadImage($path,$request->letter_head);

            if ($response['status'] == true) {
                $data['watermark'] = $response['file_name'];
            } else {
                return redirect()->back()->with('error', $response['message']);
            }
        }

        PrintStyleSetting::updateOrCreate(['company_id' => $company_id], $data);

        return redirect()->back()->with('success', "Print Style Setting Stored Successfully.");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
