<?php

namespace App\Http\Controllers\Product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ProductPrice;

class ProductPricesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('product-prices.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'batch'          => 'required',
            'purchase_price' => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);

        $data['exp_date'] = isset($data['exp_date']) && $data['exp_date'] != '' ? date('Y-m-d', strtotime($data['exp_date'])) : '';
        $data['mfg_date'] = isset($data['mfg_date']) && $data['mfg_date'] != '' ? date('Y-m-d', strtotime($data['mfg_date'])) : '';

        $price = ProductPrice::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Price has been created successfully',
            ]);
        }
        return redirect()->back()
            ->with('success','Price has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $price = ProductPrice::find($id);

        return view('product-prices.edit', compact('price'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'batch'          => 'required',
            'purchase_price' => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);

        $price = ProductPrice::find($id);

        if (!$price) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => "Price not found!",
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', "Price not found!");
        }

        $data['exp_date'] = isset($data['exp_date']) && $data['exp_date'] != '' ? date('Y-m-d', strtotime($data['exp_date'])) : '';
        $data['mfg_date'] = isset($data['mfg_date']) && $data['mfg_date'] != '' ? date('Y-m-d', strtotime($data['mfg_date'])) : '';

        $price->update($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Price has been Updated successfully',
            ]);
        }
        return redirect()->back()
            ->with('success','Price has been Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function changeStatus(Request $request)
    {
       if ($request->ajax())
       {
           $data   = array('status' => $request->status);
           $Update = ProductPrice::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Status successfully updated.'],
                   'data'=>[
                       'redirect'=>'/buckets/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
    }
}
