<?php

namespace App\Http\Controllers\Settings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MasterSetting;
use App\Models\AdvanceSetting;

class AdvanceSettingsController extends Controller
{
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = MasterSetting::with('advance_setting');

        if ($request->ajax()) {
            $sort_by      = $request->get('sortby') ?? 10;
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $data = $data->when(!empty($search_query), function ($query) use ($search_query) {
                        return $query->where('value', 'like', '%'.$search_query.'%');
                    })
                    ->paginate($sort_by);

            return view('advance-settings.table', compact('data'));
        }
        else
        {
            $data = $data->paginate(10);

            return view('advance-settings.index',compact('data'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $master_settings = MasterSetting::where('status',1)->get();

        $existingField = AdvanceSetting::get()
                ->pluck('value', 'master_setting_id');

        return view('advance-settings.create', compact('master_settings','existingField'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->except([
            '_token',
            '_method'
        ]);

        foreach($data as $key => $value) {
            AdvanceSetting::updateOrCreate(["master_setting_id" => $key],["value" => $value]);
        }

        return redirect()->route('advance-settings.index')
            ->with('success','Setting has been stored successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $field = MasterSetting::with('advance_setting')->find($id);

        return view('advance-settings.edit', compact('field'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        AdvanceSetting::updateOrCreate(["master_setting_id" => $id],["value" => $request->value]);

        return response()->json([
            'success' => true,
            'message' => 'Advance Settings Updated successfully',
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
