<?php

namespace App\Http\Controllers\Settings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SoftwareBranding;

class SoftwareBrandingController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:software-branding-list|software-branding-create|software-branding-edit|software-branding-delete', ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $branding = SoftwareBranding::first();

        return view('software-branding.index', compact('branding'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'company_name' => 'required',
            'website'      => 'required',
            'company_logo' => 'mimes:jpg,jpeg,png,gif'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            'company_logo',
            '_method'
        ]);

        $field = SoftwareBranding::find($id);

        //move | upload file on server
         if ($request->hasFile('company_logo')) {
            $file          = $request->file('company_logo');
            $extension     = $file->getClientOriginalExtension();
            $filename      = 'software-branding-'.time() . '.' . $extension;
            $file->move('uploads/software-branding/', $filename);
            $data['company_logo'] = $filename;

            if ($field->company_logo != '' && file_exists('uploads/software-branding/' . $field->company_logo)) {
                unlink('uploads/software-branding/' . $field->company_logo);
            }
        }
        if (!$field) {
            return redirect()->back()
                ->with('error','Branding detail not found not found!');
        }

        $field->update($data);

        return redirect()->back()
            ->with('success','Branding details updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
