<?php

namespace App\Http\Controllers\Stocks;

use App\Http\Controllers\Controller;
use App\Models\Company;
use App\Models\Stocks\ProductShortlist;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ProductShortListController extends Controller
{

    protected  $mainFolderName = 'stocks';
    public function index(Request $request)
    {
        $data = ProductShortlist::select(['product_shortlists.id', 
                                          'product_shortlists.product_id',
                                           'product_shortlists.quantity',
                                           'product_shortlists.status',
                                           'product_shortlists.created_by','product_shortlists.created_at',
                                           'products.name as product_name',
                                           'users.prepared_by'])
        ->leftJoin('products','products.id','=','product_shortlists.product_id')
        ->leftJoin('users','users.id','=','product_shortlists.created_by')
        ->orderBy('id', 'desc');
        $sort_by      = $request->get('sortby') ?? 10;
        if ($request->ajax()) {
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $data = $data->when(!empty($search_query), function ($query) use ($search_query) {
                    return $query->where('products.name', 'LIKE', '%' . $search_query . '%');
            })
            ->paginate($sort_by);

            return view($this->mainFolderName . '.stock-short.table', compact('data'));
        } else {
            $data = $data
            ->paginate($sort_by);
            return view($this->mainFolderName . '.stock-short.index', compact('data'));
        }
    }

    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'product_id'   => 'required',
            'qty'          => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
        }

        /******************* Check Current Date  Product Already Restock Request or Not *************/
        $company_id   = Auth::user()->company_id ?? '';
        $user_id      = Auth::user()->id ?? '';
        $check        = ProductShortlist::where(['product_id' => $request->product_id, 'shortlist_date' => date('Y-m-d')])->first();
        if (empty($check)) {
            $dataShortList = [
                'product_id'           => $request->product_id,
                'quantity'             => $request->qty,
                'status'               => 'PENDING',
                'company_id'           => $company_id,
                'created_by'           => $user_id,
                'shortlist_date'       => date('Y-m-d')
            ];
    
            ProductShortlist::create($dataShortList);

    
            if ($request->ajax()) {
                return response()->json([
                    'success' => true,
                    'message' => 'Added to Re-Stock List',
                    'data'    => []
                ]);
            }
        }
        else
        {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => 'Already added in Re-Stock List',
                    'data'    => []
                ]);
            }
        }

        
    }
    public function statement(Request $request){
        $companyDateFormate = phpToJsDateFormat($this->companyDateFormate());
        $company       = Company::find(Auth::user()->company_id);
        $companies     = Company::get();
        $data = $this->statementQuery($request);
                                    
        if ($request->ajax()) {
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');
            $from_date         = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : date('Y-m-d');
            $to_date           = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : date('Y-m-d');
            return view($this->mainFolderName . '.stock-short.statement.table', compact('data','company'));
        }else{
            return view($this->mainFolderName.'.stock-short.statement.index',compact('data','companies','company'));
        }
    }

    public function statementQuery($request)
    {

        $from_date         = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : date('Y-m-d');
        $to_date           = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : date('Y-m-d');
        $data = ProductShortlist::select(['product_shortlists.id', 
                                'product_shortlists.product_id',
                                'product_shortlists.quantity',
                                'product_shortlists.status',
                                'product_shortlists.created_by',
                                'product_shortlists.created_at',
                                'products.name as product_name',
                                'users.prepared_by'])
            ->leftJoin('products','products.id','=','product_shortlists.product_id')
            ->leftJoin('users','users.id','=','product_shortlists.created_by')
            ->orderBy('id', 'desc')
            ->when(!empty($from_date) && !empty($to_date), function ($query) use ($from_date, $to_date) {
                
                $query->whereBetween('product_shortlists.shortlist_date', [$from_date, $to_date]);
            })
            ->get();
        return $data;

    }

    public function destroy(Request $request)
    {
        $data = ProductShortlist::find($request->id);
        $data->delete();
        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data'    => [
            ]
        ]);
    }
}
